package com.junmp.jyzb.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.junmp.jyzb.api.bean.req.ProductReq;
import com.junmp.jyzb.beanReq.PolicemanFingerReq;
import com.junmp.jyzb.domain.PoliceFinger;
import com.junmp.jyzb.entity.Product;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.v2.db.api.page.PageResult;

import java.util.List;
import java.util.Map;


public interface PoliceFingerService extends IService<PoliceFinger> {

    List<Map<String, Object>> getFingersByUserId(String userId);

    /**
     * 新增指纹信息
     * @param req
     * @return
     */
    boolean addFingerInfo(PolicemanFingerReq req);

    /**
     * 更新指纹信息
     * @param req
     * @return
     */
    boolean updateFingerInfo(PolicemanFingerReq req);

    /**
     * 查询指纹信息列表
     * @param req
     * @return
     */
    List<PoliceFinger> searchFingerInfo(PolicemanFingerReq req);

    /**
     * 删除指纹信息
     * @param req
     * @return
     */
    boolean deleteFinger(PolicemanFingerReq req);


    /**
     * 分页信息
     * @param req
     * @return
     */
    PageResult<PoliceFinger> findPage(PolicemanFingerReq req);
}
