package com.junmp.jyzb.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.junmp.jyzb.api.bean.req.ProductReq;
import com.junmp.jyzb.beanReq.CabinetReq;
import com.junmp.jyzb.domain.Cabinet;
import com.junmp.jyzb.domain.PoliceFinger;
import com.junmp.jyzb.utils.ResponseResult;

import java.util.List;
import java.util.Map;

public interface CabinetService extends IService<Cabinet> {

    ResponseResult addCabinet(Map<String, Object> msg);

    ResponseResult deleteCabinet(Map<String, Object> msg);

    List<String> getAllCabinetId(Map<String, Object> orgId);

    Map<String, Object> getOneCabinet(String cabinetId);

    ResponseResult updateCabinet(Map<String, Object> msg);

    ResponseResult changeCabinetState(Map<String, Object> msg);

    List<String> getAllCabinetBoxId(String id);

    ResponseResult getAllCabinet(Map<String, Object> msg);

    ResponseResult getCabinetDetail(Map<String, Object> msg);

    ResponseResult setCabinetInventory(Map<String, Object> msg);

    /**
     * 添加单警柜
     * @param req
     * @return
     */
    boolean addCabinet(CabinetReq req) throws Exception;

    /**
     * 删除单警柜
     * @param req
     * @return
     */
    boolean deleteCabinet(CabinetReq req);

    /**
     * 查询单警柜信息
     * @param req
     * @return
     */
    List<Cabinet> getAllCabinet(CabinetReq req,String includeLowerLevel);

    /**
     * 修改单警柜信息
     * @param req
     * @return
     */
    boolean updateCabinet(CabinetReq req) throws Exception;
}
