package com.junmp.jyzb.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.junmp.jyzb.entity.ProductSku;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/7/29 16:25
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Mapper
public interface ProductSkuMapper extends BaseMapper<ProductSku> {

    /**
     * 获取当前产品最大序号
     *
     * @param productId 产品编号
     */
    Integer getMaxSn(@Param("productId") Long productId);


    /**
     * 删除产品对应的号型
     *
     * @param productId 产品编号
     */
    boolean delByProductId(@Param("productId") Long productId);
}
