package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;

/**
 * <pre>
 *
 * 描述：产品SKU
 * 版本：1.0.0
 * 日期：2022/7/29 16:19
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Data
@TableName("biz_product_sku")
public class ProductSku implements Serializable {

    @TableId(type = IdType.AUTO, value = "spec_id")
    private Long specId;

    /**
     * 号型代码
     */
    @TableField(value = "spec_code")
    private String specCode;

    /**
     * SKU编码
     */
    @TableField(value = "sku_code")
    private String skuCode;

    /**
     * 序号
     */
    private Integer sn;

    /**
     * 号型
     */
    private String spec;

    /**
     * 重量
     */
    private String weight;

    /**
     * 材质
     */
    private String material;


    /**
     * 关联产品
     */
    @TableField(value = "product_id")
    private Long productId;

    /**
     * 预览属性1
     */
    private String attr1;

    /**
     * 预览属性2
     */
    private String attr2;

    /**
     * 预览属性3
     */
    private String attr3;


}
