package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;


@Data
@TableName("base_inventory")
public class EquipmentType implements Serializable {

    /**
     * 装备类型ID
     */
    private String id;

    /**
     * 类型名称
     */
    private String name;

    /**
     * 单位
     */
    private String unit;

    /**
     * 单位类型
     */
    @TableField(value = "unit_type")
    private String unitType;

    /**
     * 装备Code码
     */
    private String code;

    /**
     * 上级id
     */
    @TableField(value = "parent_id")
    private String parentId;

    /**
     * 上级ids
     */
    @TableField(value = "parent_ids")
    @ApiModelProperty(value = "上级id")
    private String parentIds;

    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.UPDATE)
    private Date updateTime;


    /**
     * 当前状态:0关闭/1启用
     */
    @ApiModelProperty(value = "当前状态:0关闭/1启用")
    private Integer state;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String note;

    /**
     * 类型，0类别，1装备
     */
    @ApiModelProperty(value = "类型，0类别，1装备")
    private Integer type;

    private static final long serialVersionUID = 1L;
}
