package com.junmp.jyzb.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value="com-junmp-jyzb-domain-SupplierType")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SupplierType implements Serializable {
    /**
    * 供应商产品ID
    */
    @ApiModelProperty(value="供应商产品ID")
    private String id;

    /**
    * 供应商代码
    */
    @ApiModelProperty(value="供应商代码")
    private String supplierId;

    /**
    * 产品代码
    */
    @ApiModelProperty(value="产品代码")
    private String typeId;

    /**
    * 状态，0:停用，1:启用
    */
    @ApiModelProperty(value="状态，0:停用，1:启用")
    private Integer state;

    /**
    * 创建时间
    */
    @ApiModelProperty(value="创建时间")
    private Date createTime;

    /**
    * 最后更新时间
    */
    @ApiModelProperty(value="最后更新时间")
    private Date updateTime;

    /**
    * 更新人ID
    */
    @ApiModelProperty(value="更新人ID")
    private String updateUser;

    private static final long serialVersionUID = 1L;
}