package com.junmp.jyzb.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value = "com-junmp-jyzb-domain-PackageInformation")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class PackageInformation implements Serializable {
    /**
     * 装备包详细信息id
     */
    @ApiModelProperty(value = "装备包详细信息id")
    private String id;

    /**
     * 装备包id
     */
    @ApiModelProperty(value = "装备包id")
    private String packageId;

    /**
     * 装备类型id
     */
    @ApiModelProperty(value = "装备类型id")
    private String typeId;

    /**
     * 装备类型名称
     */
    @ApiModelProperty(value = "装备类型名称")
    private String typeName;

    /**
     * 装备号型id
     */
    @ApiModelProperty(value = "装备号型id")
    private String sizeId;

    /**
     * 装备号型名称
     */
    @ApiModelProperty(value = "装备号型名称")
    private String sizeName;

    /**
     * 装备数量
     */
    @ApiModelProperty(value = "装备数量")
    private Integer number;

    private static final long serialVersionUID = 1L;
}