package com.junmp.jyzb.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

@ApiModel(value="com-junmp-jyzb-domain-BussinessOrderMain")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class OrderMain implements Serializable {
    @ApiModelProperty(value="")
    private Long id;

    /**
    * 单据类型：入库单/出库单
    */
    @ApiModelProperty(value="单据类型：入库单/出库单")
    private String orderType;

    /**
     * 工作流ID
     */
    @ApiModelProperty(value="工作流ID")
    private String processId;

    /**
    * 单据业务类型：purchase采购/gift赠予/other其他类型
    */
    @ApiModelProperty(value="单据业务类型：purchase采购/gift赠予/other其他类型")
    private String bussinessType;

    /**
    * 订单号
    */
    @ApiModelProperty(value="订单号")
    private String orderCode;

    /**
     * 目标单位
     */
    @ApiModelProperty(value="目标单位")
    private String orgId;

    /**
    * 审批状态：0未审批/1已审批/
    */
    @ApiModelProperty(value="审批状态：0未审批/1已审批/")
    private String approveType;

    /**
    * 发物单位
    */
    @ApiModelProperty(value="发物单位")
    private String sendOrgId;

    /**
    * 发物单位名称
    */
    @ApiModelProperty(value="发物单位名称")
    private String sendOrgName;

    /**
    * 应入库数量
    */
    @ApiModelProperty(value="应入库数量")
    private Integer inventoryQuantity;

    /**
    * 实际数量
    */
    @ApiModelProperty(value="实际数量")
    private Integer actualQuantity;

    /**
    * 是否已记账 0未记账/1已记账
    */
    @ApiModelProperty(value="是否已记账 0未记账/1已记账")
    private Integer manualState;

    /**
    * 单据状态 0待入库/1已入库/2入库中
    */
    @ApiModelProperty(value="单据状态 0待入库/1已入库/2入库中")
    private Integer orderState;

    /**
    * 附件地址
    */
    @ApiModelProperty(value="附件地址")
    private String attachmentLocation;

    /**
    * 单据包含的物资集合，内容以逗号进行分割
    */
    @ApiModelProperty(value="单据包含的物资集合，内容以逗号进行分割")
    private String invList;

    /**
    * 创建时间
    */
    @ApiModelProperty(value="创建时间")
    private Date createTime;

    /**
    * 更新时间
    */
    @ApiModelProperty(value="更新时间")
    private Date updateTime;

    /**
    * 创建人员
    */
    @ApiModelProperty(value="创建人员")
    private String createUser;

    /**
    * 更新人员
    */
    @ApiModelProperty(value="更新人员")
    private String updateUser;

    private static final long serialVersionUID = 1L;
}