package com.junmp.jyzb.controller;

import com.junmp.jyzb.service.MsgService;
import com.junmp.jyzb.utils.ResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Map;

@RestController
@Slf4j
@RequestMapping("/User")
@Api(tags = "根据表明和组织机构id获取相关信息")
public class UserController {
    @Resource
    public MsgService msgService;

    @PostMapping("/GetMsg")
    @ApiOperation("获取相关信息")
    public ResponseResult getMsg(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = msgService.getMsg(msg);
        return returnMsg;
    }

    @PostMapping("/GetUserMsg")
    @ApiOperation("根据组织机构获取用户信息")
    public ResponseResult getUserMsg(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = msgService.getUserMsg(msg);
        return returnMsg;
    }
}
