package com.junmp.jyzb.controller;

import com.junmp.jyzb.beanReq.PolicemanFingerReq;
import com.junmp.jyzb.doc.PolicemanFingerDoc;
import com.junmp.jyzb.domain.PoliceFinger;
import com.junmp.jyzb.service.PoliceFingerService;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

@RestController
@Slf4j
@RequestMapping("/PolicemanFinger")
@Api(tags = "警员指纹信息模块")
public class PolicemanFingerController implements PolicemanFingerDoc {

    @Resource
    PoliceFingerService policeFingerService;

    @PostMapping("/AddFingerInfo")
    @ApiOperation("添加指纹信息")
    public ApiRes<Boolean> addFingerInfo(@RequestBody @Validated(PolicemanFingerReq.edit.class) PolicemanFingerReq req) {
        return ApiRes.success(policeFingerService.addFingerInfo(req)) ;

    }

    @PostMapping("/updateFingerInfo")
    @ApiOperation("修改指纹信息")
    public ApiRes<Boolean> updateFingerInfo(@RequestBody @Validated(PolicemanFingerReq.edit.class) PolicemanFingerReq req) {
        return ApiRes.success(policeFingerService.updateFingerInfo(req)) ;

    }

    @PostMapping("/searchFingerInfo")
    @ApiOperation("查找指纹信息")
    public ApiRes<List<PoliceFinger>> searchFingerInfo(@RequestBody @Validated(PolicemanFingerReq.edit.class) PolicemanFingerReq req) {
        return ApiRes.success(policeFingerService.searchFingerInfo(req));
    }

    @PostMapping("/DeleteFingerInfo")
    @ApiOperation("删除警员指纹信息")
    public ApiRes<Boolean> deletePoliceFinger(@RequestBody @Validated(PolicemanFingerReq.edit.class) PolicemanFingerReq req) {
        return ApiRes.success(policeFingerService.deleteFinger(req));
    }

    @ApiOperation("/分页信息")
    @GetMapping(path = "/page", name = "指纹信息分页")
    public ApiRes<PageResult<PoliceFinger>> page(PolicemanFingerReq req) {
        return ApiRes.success(policeFingerService.findPage(req));
    }
}
