package com.junmp.jyzb.controller;

import com.junmp.jyzb.service.CabinetBoxService;
import com.junmp.jyzb.service.CabinetService;
import com.junmp.jyzb.service.PoliceFingerService;
import com.junmp.jyzb.utils.HttpStatus;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.jyzb.utils.ReturnData;
import com.junmp.jyzb.utils.ReturnMsg;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@RestController
@Slf4j
@RequestMapping("/Cabinet")
@Api(tags = "单警柜基础信息模块")
public class CabinetController {
    @Resource
    public CabinetService cabinetService;

    @Resource
    private CabinetBoxService cabinetBoxService;

    @PostMapping("/AddCabinet")
    @ApiOperation("添加单警柜")
    public ResponseResult addCabinet(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = cabinetService.addCabinet(msg);
        return returnMsg;
    }

    @PostMapping("/DeleteCabinet")
    @ApiOperation("删除单警柜信息")
    public ResponseResult deleteCabinet(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = cabinetService.deleteCabinet(msg);
        return returnMsg;
    }

    @PostMapping("/ShowCabinet")
    @ApiOperation("查询单警柜列表")
    public ResponseResult showCabinet(@RequestBody Map<String, Object> msg){
        ResponseResult returnMsg = cabinetService.getAllCabinet(msg);
        return returnMsg;
    }

    @PostMapping("/UpdateCabinet")
    @ApiOperation("修改单警柜信息")
    public ResponseResult updateCabinet(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg =cabinetService.updateCabinet(msg);
        return returnMsg;
    }

    @PostMapping("/ErrorState")
    @ApiOperation("单警柜状态变更")
    public ResponseResult changeCabinetState(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = cabinetService.changeCabinetState(msg);
        return returnMsg;
    }

    @PostMapping("/GetCabinetDetail")
    @ApiOperation("查询单警柜及其箱号信息")
    public ResponseResult getCabinetDetail(@RequestBody Map<String, Object> msg){
        ResponseResult returnMsg = cabinetService.getCabinetDetail(msg);
        return returnMsg;
    }


    @PostMapping("/getCabinetBoxInfo")
    @ApiOperation("获取箱门列表")
    public ResponseResult getCabinetBoxInfo(@RequestBody Map<String, Object> msg){
        ResponseResult returnMsg = cabinetBoxService.getCabinetBoxInfo(msg);
        return returnMsg;
    }

}