package com.junmp.jyzb.beanReq;

import com.junmp.v2.common.bean.request.BaseRequest;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = true)
public class PolicemanFingerReq extends BaseRequest {
    /**
     * 指纹id
     */
    @NotNull(message = "指纹主键不能为空", groups = {edit.class, delete.class, detail.class})
    @ApiModelProperty(value = "指纹id")
    private Integer id;

    /**
     * 警员id
     */
    @NotNull(message = "警员id不能为空", groups = {edit.class, delete.class, detail.class})
    @ApiModelProperty(value = "警员id")
    private String policeId;

    /**
     * 指纹名称
     */
    @ApiModelProperty(value = "警员id")
    private String name;

    /**
     * 指纹信息
     */
    @NotNull(message = "指纹信息不能为空", groups = {edit.class, delete.class, detail.class})
    @ApiModelProperty(value = "指纹信息")
    private String fingerInfo;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    private static final long serialVersionUID = 1L;
}
