package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.req.ManufacturerReq;
import com.junmp.jyzb.entity.Manufacturer;
import com.junmp.jyzb.service.ManufacturerService;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@RestController
@Slf4j
@RequestMapping("/Manufacturer")
@Api(tags = "生产厂商模块")
public class ManufacturerController {
    @Resource
    private ManufacturerService manufacturerService;

    //创建生产厂商
    @PostMapping("/AddManufacturer")
    @ApiOperation("创建生产厂商")
    public ApiRes<String> addManufacturer(@RequestBody @Validated(ValidationApi.add.class) ManufacturerReq req){
        return ApiRes.success(manufacturerService.addManufacturer(req));
    }

    //修改生产厂商
    @PostMapping("/UpdateManufacturer")
    @ApiOperation("修改生产厂商")
    public ApiRes<Boolean> updateManufacturer(@RequestBody @Validated(ValidationApi.edit.class) ManufacturerReq req){
        return ApiRes.success(manufacturerService.updateManufacturer(req));
    }

    //查询生产厂商(list)
    @PostMapping("/ShowManufacturerList")
    @ApiOperation("查询生产厂商(list)")
    public ApiRes<List<Manufacturer>> showManufacturerList(@RequestBody ManufacturerReq req){
        return ApiRes.success(manufacturerService.showManufacturerList(req));
    }

    //查询生产厂商(page)
    @PostMapping("/ShowManufacturerPage")
    @ApiOperation("修改生产厂商(page)")
    public ApiRes<PageResult<Manufacturer>> showManufacturerPage(@RequestBody ManufacturerReq req){
        return ApiRes.success(manufacturerService.showManufacturerPage(req));
    }
    //删除生产厂商
    @PostMapping("/DelManufacturer")
    @ApiOperation("修改生产厂商")
    public ApiRes<Boolean> delManufacturer(@RequestBody ManufacturerReq req){
        return ApiRes.success(manufacturerService.delManufacturer(req));
    }
}

