package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 
 * @TableName base_warehouse_inventory
 */
@TableName(value ="base_warehouse_inventory")
@Data
public class WarehouseInventory implements Serializable {
    /**
     * 
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 组织机构Id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 类型id
     */
    @TableField(value = "type_id")
    private String typeId;

    /**
     * 号型id
     */
    @TableField(value = "size_id")
    private String sizeId;

    /**
     * 位置id
     */
    @TableField(value = "location_id")
    private String locationId;

    /**
     * 所属位置:0仓库，1单警柜
     */
    @TableField(value = "location_type")
    private String locationType;

    /**
     * EPC信息
     */
    @TableField(value = "epc")
    private String epc;

    /**
     * 0,正常，1不做提醒
     */
    @TableField(value = "flag")
    private Integer flag;

    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(value = "update_time")
    private Date updateTime;

    /**
     * 更新人员
     */
    @TableField(value = "update_user")
    private String updateUser;

    /**
     * 创建人员
     */
    @TableField(value = "create_user")
    private String createUser;

    /**
     * 在库状态:in在库，out出库
     */
    @TableField(value = "location_state")
    private String locationState;

    /**
     * 货架位置
     */
    @TableField(value = "shelf_location")
    private String shelfLocation;

    /**
     * 货架ID
     */
    @TableField(value = "shelf_id")
    private String shelfId;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

}