package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.dto.FetchingDataDto.DeviceConfigInfoDto;
import com.junmp.jyzb.api.bean.dto.FetchingDataDto.WarehouseDevInfoDto;
import com.junmp.jyzb.api.bean.query.QueryDeviceConfigReq;
import com.junmp.jyzb.api.bean.req.UpdateDeivceConfigReq;
import com.junmp.jyzb.api.bean.req.UpdateWarehouseDevReq;
import com.junmp.jyzb.entity.DeviceConfig;
import com.junmp.jyzb.entity.WarehouseDev;
import com.junmp.jyzb.service.DeviceConfigService;
import com.junmp.jyzb.service.WarehouseDevService;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@RestController
@Slf4j
@RequestMapping("/DeviceConfig")
@Api(tags = "[配置]配置信息模块")
public class DeviceConfigController {
    @Resource
    private DeviceConfigService deviceConfigService;

    @Resource
    private WarehouseDevService warehouseDevService;

    //新增配置
    @PostMapping(path="/addDeviceConfig",name="新增配置#logType=30")
    @ApiOperation("新增配置")
    public ApiRes<Long> addDeviceConfig(@RequestBody UpdateDeivceConfigReq req){
        return ApiRes.success(deviceConfigService.addDeviceConfig(req));
    }
    //修改配置
    @PostMapping(path="/updateDeviceConfig",name="修改配置#logType=30")
    @ApiOperation("修改配置")
    public ApiRes<Boolean> updateDeviceConfig(@RequestBody UpdateDeivceConfigReq req){
        return ApiRes.success(deviceConfigService.updateDeviceConfig(req));
    }
    //查询配置Page
    @PostMapping(path="/showDeviceConfigPage",name="查询配置Page#enable")
    @ApiOperation("查询配置Page")
    public ApiRes<PageResult<DeviceConfig>> showDeviceConfigPage(@RequestBody QueryDeviceConfigReq req){
        return ApiRes.success(deviceConfigService.showDeviceConfigPage(req));
    }
    //查询配置List
    @PostMapping(path="/showDeviceConfigList",name="查询配置List#enable")
    @ApiOperation("查询配置List")
    public ApiRes<List<DeviceConfig>> showDeviceConfigList(@RequestBody QueryDeviceConfigReq req){
        return ApiRes.success(deviceConfigService.showDeviceConfigList(req));
    }

    //新增除湿机配置
    @PostMapping(path="/addWarehouseDev",name="新增除湿机配置#logType=30")
    @ApiOperation("新增除湿机配置")
    public ApiRes<String> addWarehouseDev(@RequestBody UpdateWarehouseDevReq req){
        return ApiRes.success(warehouseDevService.addWarehouseDev(req));
    }
    //修改除湿机配置
    @PostMapping(path="/updateWarehouseDev",name="修改除湿机配置#logType=30")
    @ApiOperation("修改除湿机配置")
    public ApiRes<Boolean> updateWarehouseDev(@RequestBody UpdateWarehouseDevReq req){
        return ApiRes.success(warehouseDevService.updateWarehouseDev(req));
    }
    //查看除湿机配置
    @PostMapping(path="/showWarehouseDevList",name="查看除湿机配置#enable")
    @ApiOperation("查看除湿机配置")
    public ApiRes<List<WarehouseDev>> showWarehouseDevList(@RequestBody @Validated(ValidationApi.list.class) UpdateWarehouseDevReq req){
        return ApiRes.success(warehouseDevService.showWarehouseDevList(req));
    }

    @PostMapping(path="/alignDeviceConfigInfo",name="同步更新通道/仓库主机配置#logType=30")
    @ApiOperation("同步更新通道/仓库主机配置")
    public ApiRes<List<String>> alignDeviceConfigInfo(@RequestBody UpdateDeivceConfigReq req){
        return ApiRes.success(deviceConfigService.alignDeviceConfigInfo(req));
    }


    @PostMapping(path="/alignWarehouseDevInfo",name="同步更新除湿机配置#logType=30")
    @ApiOperation("同步更新除湿机配置")
    public ApiRes<List<WarehouseDevInfoDto>> alignWarehouseDevInfo(@RequestBody UpdateWarehouseDevReq req){
        return ApiRes.success(warehouseDevService.alignWarehouseDevInfo(req));
    }

}
