package com.junmp.jyzb.utils;

import com.junmp.jyzb.domain.Policeman;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class ObjectToMap {
    public static Map<String, Object> toMap(Object obj) {
        Map<String, Object> map = new HashMap<>();
        Class<?> cls = obj.getClass();

        // 获取对象的所有属性
        Field[] fields = cls.getDeclaredFields();
        for (Field field : fields) {
            try {
                // 设置字段可访问，以便获取其值
                field.setAccessible(true);
                // 将字段名和字段值添加到Map中
                map.put(field.getName(), field.get(obj));
            } catch (IllegalAccessException e) {
                // 处理异常
                e.printStackTrace();
            }
        }
        return map;
    }
}
