package com.junmp.jyzb.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value = "com-junmp-jyzb-domain-Supplier")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class Supplier implements Serializable {
    /**
     * 供应商ID
     */
    @ApiModelProperty(value = "供应商ID")
    private String id;

    /**
     * 装备类型ID
     */
    @ApiModelProperty(value = "装备类型ID")
    private String equipmentId;

    /**
     * 供应商名称
     */
    @ApiModelProperty(value = "供应商名称")
    private String name;

    /**
     * 供应商短码
     */
    @ApiModelProperty(value = "供应商短码")
    private String code;

    /**
     * 简称
     */
    @ApiModelProperty(value = "简称")
    private String shortName;

    /**
     * 联系方式
     */
    @ApiModelProperty(value = "联系方式")
    private String contacts;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    /**
     * 创建人员
     */
    @ApiModelProperty(value = "创建人员")
    private String createUser;

    /**
     * 最后更新时间
     */
    @ApiModelProperty(value = "最后更新时间")
    private Date updateTime;

    /**
     * 更新人ID
     */
    @ApiModelProperty(value = "更新人ID")
    private String updateUser;

    /**
     * 联系方式
     */
    @ApiModelProperty(value = "联系方式")
    private String phone;

    /**
     * 状态码
     */
    @ApiModelProperty(value = "状态码")
    private Integer state;

    private static final long serialVersionUID = 1L;
}