package com.junmp.jyzb.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 组织机构信息
 */
@ApiModel(value="com-junmp-jyzb-domain-PubOrg")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class PubOrg implements Serializable {
    /**
     * 主键
     */
    @ApiModelProperty(value="主键")
    private Long orgId;

    /**
     * 父id，一级节点父id是0
     */
    @ApiModelProperty(value="父id，一级节点父id是0")
    private Long orgParentId;

    /**
     * 父ids
     */
    @ApiModelProperty(value="父ids")
    private String orgParentIds;

    /**
     * 组织编码
     */
    @ApiModelProperty(value="组织编码")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(value="组织名称")
    private String orgName;

    /**
     *
     */
    @ApiModelProperty(value="")
    private String areaName;

    /**
     *
     */
    @ApiModelProperty(value="")
    private String dName;

    /**
     * 机构类型100企业，101：机构
     */
    @ApiModelProperty(value="机构类型100企业，101：机构")
    private Short orgType;

    /**
     * 排序
     */
    @ApiModelProperty(value="排序")
    private Byte sortVal;

    /**
     * 状态：1-启用，2-禁用
     */
    @ApiModelProperty(value="状态：1-启用，2-禁用")
    private Byte statusFlag;

    /**
     * 描述
     */
    @ApiModelProperty(value="描述")
    private String remark;

    /**
     * 删除标记：Y-已删除，N-未删除
     */
    @ApiModelProperty(value="删除标记：Y-已删除，N-未删除")
    private Short delFlag;

    /**
     * 机构全称
     */
    @ApiModelProperty(value="机构全称")
    private String orgFullName;

    /**
     * 地址
     */
    @ApiModelProperty(value="地址")
    private String address;

    /**
     * 联系人
     */
    @ApiModelProperty(value="联系人")
    private String contact;

    /**
     * 电话
     */
    @ApiModelProperty(value="电话")
    private String phone;

    /**
     * 创建时间
     */
    @ApiModelProperty(value="创建时间")
    private Date createTime;

    /**
     * 创建人
     */
    @ApiModelProperty(value="创建人")
    private Long createUser;

    /**
     * 更新时间
     */
    @ApiModelProperty(value="更新时间")
    private Date updateTime;

    /**
     * 更新人
     */
    @ApiModelProperty(value="更新人")
    private Long updateUser;

    @ApiModelProperty(value="")
    private String guid;

    @ApiModelProperty(value="")
    private String findCode;

    private static final long serialVersionUID = 1L;
}