package com.junmp.jyzb.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value = "com-junmp-jyzb-domain-LogDetail")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class LogDetail implements Serializable {
    /**
     * 出入库明细ID
     */
    @ApiModelProperty(value = "出入库明细ID")
    private Integer id;

    /**
     * 出入库汇总ID
     */
    @ApiModelProperty(value = "出入库汇总ID")
    private Integer summaryId;

    /**
     * 单据ID
     */
    @ApiModelProperty(value = "单据ID")
    private String orderId;

    /**
     * EPC信息
     */
    @ApiModelProperty(value = "EPC信息")
    private String epc;

    /**
     * 装备名称
     */
    @ApiModelProperty(value = "装备名称")
    private String equipmentName;

    /**
     * 装备号型
     */
    @ApiModelProperty(value = "装备号型")
    private String equipmentSize;

    /**
     * 供应商
     */
    @ApiModelProperty(value = "供应商")
    private String equipmentSupplier;

    /**
     * 装备类型:0单件/1装备包
     */
    @ApiModelProperty(value = "装备类型:0单件/1装备包")
    private Integer equipmentType;

    /**
     * 状态，0正常/1异常
     */
    @ApiModelProperty(value = "状态，0正常/1异常")
    private Integer errorState;

    /**
     * 备注信息
     */
    @ApiModelProperty(value = "备注信息")
    private String note;

    private static final long serialVersionUID = 1L;
}