package com.junmp.jyzb.doc;

import com.junmp.jyzb.api.bean.req.ProductSkuReq;
import com.junmp.jyzb.api.bean.vo.ProductSkuVo;
import com.junmp.jyzb.entity.ProductSku;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.util.List;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/8/1 18:00
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Api(value = "号型管理", tags = "产品号型接口")
public interface ProductSkuDoc {


    /**
     * 新增产品号型
     *
     * @param req
     */
    @ApiOperation(value = "新增产品号型", tags = "产品号型接口")
    ApiRes<Boolean> addProductSku(ProductSkuReq req);

    /**
     * 新增产品号型
     *
     * @param req
     */
    @ApiOperation(value = "编辑号型", tags = "产品号型接口")
    ApiRes<Boolean> editProductSku(ProductSkuReq req);


    /**
     * 新增产品号型
     *
     * @param req
     */
    @ApiOperation(value = "删除号型", tags = "产品号型接口")
    ApiRes<Boolean> del(ProductSkuReq req);

    /**
     * 新增产品号型
     *
     * @param req
     */
    @ApiOperation(value = "分页产品信息", tags = "产品号型接口")
    ApiRes<PageResult<ProductSku>> page(ProductSkuReq req);


    /**
     * 获取指定产品号型列表
     */
    @ApiOperation(value = "获取指定产品号型列表", tags = "产品号型接口")
    ApiRes<List<ProductSkuVo>> listByProduct(ProductSkuReq req);

}
