package com.junmp.jyzb.controller;

import com.junmp.jyzb.service.PubOrgService;
import com.junmp.jyzb.utils.ResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Map;

@RestController
@Slf4j
@RequestMapping("/PubOrg")
@Api(tags = "组织机构模块")
public class PubOrgController {
    @Resource
    public PubOrgService pubOrgService;

    @PostMapping("/ShowPubOrgList")
    @ApiOperation("查询组织机构列表_简化版")
    public ResponseResult ShowEquipmentList(@RequestBody Map<String, Object> orgId) {
        //传入当前的组织机构id，展示所有本级及下级的
        ResponseResult returnMsg = pubOrgService.showPubOrgList(orgId);
        return returnMsg;
    }

//    @PostMapping("/ShowPubOrgListOld")
//    @ApiOperation("查询组织机构列表_完整版")
//    public ResponseResult showPubOrgListOld(@RequestBody Map<String, Object> orgId) {
//        //传入当前的组织机构id，展示所有本级及下级的
//        ResponseResult returnMsg = pubOrgService.showPubOrgListOld(orgId);
//        return returnMsg;
//    }

    @PostMapping("/SetOrgParentIds")
    @ApiOperation("填充组织机构的parent_ids字段")
    public ResponseResult setOrgParentIds() {
        //传入当前的组织机构id，展示所有本级及下级的
        ResponseResult returnMsg = pubOrgService.setOrgParentIds();
        return returnMsg;
    }

    @PostMapping("/SetDName")
    @ApiOperation("填充组织机构简称到数据库")
    public ResponseResult setShortName(@RequestBody Map<String, Object> orgId) {
        //传入当前的组织机构id，展示所有本级及下级的
        ResponseResult returnMsg = pubOrgService.setShortName(orgId);
        return returnMsg;
    }

    @PostMapping("/GetOrgDetail")
    @ApiOperation("查询组织机构详细信息")
    public ResponseResult getOrgDetail(@RequestBody Map<String, Object> msg) {
        //传入当前的组织机构id，展示所有本级及下级的
        ResponseResult returnMsg = pubOrgService.getOrgDetail(msg);
        return returnMsg;
    }
}
