package com.junmp.jyzb.controller;

import com.junmp.jyzb.service.OrderService;
import com.junmp.jyzb.utils.ResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Map;

@RestController
@Slf4j
@RequestMapping("/Order")
@Api(tags = "业务模块")
public class OrderController {
    @Resource
    public OrderService orderService;

    @PostMapping("/AddOrder")
    @ApiOperation("新增任务单")
    public ResponseResult addOrder(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = orderService.addOrder(msg);
        return returnMsg;
    }

    @PostMapping("/ShowOrder")
    @ApiOperation("查询任务列表")
    public ResponseResult showOrder(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = orderService.showOrder(msg);
        return returnMsg;
    }

    @PostMapping("/UpdateOrder")
    @ApiOperation("修改任务单")
    public ResponseResult updateOrder(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg =orderService.updateOrder(msg);
        return returnMsg;
    }

    @PostMapping("/GetOrderDetail")
    @ApiOperation("根据订单id查看业务明细")
    public ResponseResult getOrderDetail(@RequestBody Map<String, Object> msg){
        ResponseResult returnMsg = orderService.getOrderDetail(msg);
        return returnMsg;
    }
}
