package com.junmp.junmpProcess.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.PageUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.junmp.junmpProcess.common.utils.HttpStatus;
import com.junmp.junmpProcess.common.utils.ResponseResult;
import com.junmp.junmpProcess.common.utils.ReturnMsg;
import com.junmp.junmpProcess.dto.*;
import com.junmp.junmpProcess.dto.json.ProcessUser;
import com.junmp.junmpProcess.dto.json.UserInfo;
import com.junmp.junmpProcess.entity.ProcessTemplates;
import com.junmp.junmpProcess.factory.FlowServiceFactory;
import com.junmp.junmpProcess.mapper.OrgUserMapper;
import com.junmp.junmpProcess.service.IFlowInstanceService;
import com.junmp.junmpProcess.service.IFlowTaskService;
import com.junmp.junmpProcess.service.Repository.ProcessTemplateService;
import com.junmp.junmpProcess.vo.*;
import com.junmp.v2.auth.api.bean.login.LoginUser;
import com.junmp.v2.auth.api.context.LoginContext;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import com.junmp.v2.sys.user.entity.SysUser;
import com.junmp.v2.sys.user.service.SysUserService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.engine.TaskService;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.history.HistoricProcessInstanceQuery;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ActivityInstance;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.engine.task.Attachment;
import org.flowable.engine.task.Comment;
import org.flowable.task.api.DelegationState;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.flowable.variable.api.history.HistoricVariableInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.junmp.junmpProcess.common.CommonConstants.*;

@Service
@Slf4j
public class FlowTaskServiceImpl extends FlowServiceFactory implements IFlowTaskService {

    @Resource
    private SysUserService sysUserService;
    @Resource
    private OrgUserMapper orgUserMapper;

    @Autowired
    private ProcessTemplateService processTemplateService;
    @Autowired
    private IFlowInstanceService flowInstanceService;
    @Override
    public ResponseResult agree(HandleDataDTO handleDataDTO) {
        SysUser StartUser=new SysUser();
        if (handleDataDTO.getCurrentUserInfo().getUserId()!=null)//优先拿接口中的信息，方便调试
        {
            StartUser = sysUserService.getById(handleDataDTO.getCurrentUserInfo().getUserId());

        }
        else
        {
            StartUser= sysUserService.getById(LoginContext.getContext().getLoginUser());
        }
        List<AttachmentDTO> attachments = handleDataDTO.getAttachments();
        String comments = handleDataDTO.getComments();
        JSONObject formData = handleDataDTO.getFormData();
        String taskId = handleDataDTO.getTaskId();
        String processInstanceId=handleDataDTO.getProcessInstanceId();

        Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
        if (task!=null)//task为空则说明当前任务可能已结束
        {
            taskService.setVariableLocal(taskId,"taskStatusWrapper", TASK_STATUS_1);//设置当前节点任务状态

            Map<String, Object> map = new HashMap<>();
            if (formData != null && formData.size() > 0) {
                Map formValue = JSONObject.parseObject(formData.toJSONString(), new TypeReference<Map>() {
                });
                map.putAll(formValue);
                map.put(FORM_VAR, formData);
            }

            runtimeService.setVariables(task.getProcessInstanceId(), map);//设置进入当前流程

            Authentication.setAuthenticatedUserId(StartUser.getUserId().toString());
            if (StringUtils.isNotBlank(comments)) {
                taskService.addComment(task.getId(), task.getProcessInstanceId(), "opinion", comments);
            }
            if (attachments != null && attachments.size() > 0) {
                for (AttachmentDTO attachment : attachments) {
                    taskService.createAttachment("option", taskId, task.getProcessInstanceId(), attachment.getName(), attachment.getName(), attachment.getUrl());
                }
            }
            taskService.complete(task.getId());
            HistoricTaskInstance historicTask = historyService
                    .createHistoricTaskInstanceQuery()
                    .taskId(taskId)
                    .singleResult();

            if (historicTask.getEndTime()!=null)//EndTime为空，说明任务已结束，需要往消息队列中进行消息传递
            {
                HistoricProcessInstance historicProcessInstance= historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId)
                        .includeProcessVariables().singleResult();//拿到历史中的表单信息
                Map<String, Object> processVariables = historicProcessInstance.getProcessVariables();
                JSONObject jsonObject = (JSONObject) processVariables.get(FORM_VAR);


            }
            else
            {
//                HistoricVariableInstance orderType = historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstanceId).variableName("orderType").list().get(0);
//                if (orderType.equals("workOrder"))
//                {
//                    Object assigneeObject = runtimeService.getVariable(processInstanceId, "currentAssignee");
//
//                    if (assigneeObject instanceof List) {
//                        List<String> assigneeList = (List<String>) assigneeObject;
//
//                        String assigneeString = String.join(",", assigneeList);
//                        orgUserMapper.UpdateOrder("bussiness_order_main",processInstanceId,assigneeString);
//                        // 现在 assigneeString 中包含了集合元素用逗号拼接的字符串
//                    }
//                }
            }
            return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS,ReturnMsg.PASS);

        }
        else {
            return new ResponseResult(HttpStatus.PROCESS_WAS_END,ReturnMsg.PROCESS_WAS_END,"");

        }
    }

    @Override
    public ResponseResult refuse(HandleDataDTO handleDataDTO) {
        SysUser StartUser=new SysUser();
        if (handleDataDTO.getCurrentUserInfo().getUserId()!=null)//优先拿接口中的信息，方便调试
        {
            StartUser = sysUserService.getById(handleDataDTO.getCurrentUserInfo().getUserId());

        }
        else
        {
            StartUser= sysUserService.getById(LoginContext.getContext().getLoginUser());
        }
        Authentication.setAuthenticatedUserId(StartUser.getUserId().toString());
        List<AttachmentDTO> attachments = handleDataDTO.getAttachments();
        String comments = handleDataDTO.getComments();
        JSONObject formData = handleDataDTO.getFormData();
        String taskId = handleDataDTO.getTaskId();
        Task task = taskService.createTaskQuery().taskId(taskId).singleResult();

        Map<String, Object> map = new HashMap<>();
        if (formData != null && formData.size() > 0) {
            Map formValue = JSONObject.parseObject(formData.toJSONString(), new TypeReference<Map>() {
            });
            map.putAll(formValue);
            map.put(FORM_VAR, formData);
        }
        map.put(PROCESS_STATUS, BUSINESS_STATUS_3);
        taskService.setVariableLocal(taskId,"taskStatusWrapper", TASK_STATUS_2);//设置节点中的当前操作
        runtimeService.setVariables(task.getProcessInstanceId(), map);
        if (StringUtils.isNotBlank(comments)) {
            taskService.addComment(task.getId(), task.getProcessInstanceId(), "opinion", comments);
        }
        if (attachments != null && attachments.size() > 0) {
            for (AttachmentDTO attachment : attachments) {
                taskService.createAttachment("option", taskId, task.getProcessInstanceId(), attachment.getName(), attachment.getName(), attachment.getUrl());
            }
        }

        if (StringUtils.isNotBlank(handleDataDTO.getSignInfo())) {
            taskService.addComment(task.getId(), task.getProcessInstanceId(), "sign", handleDataDTO.getSignInfo());
        }
        runtimeService.deleteProcessInstance(task.getProcessInstanceId(), "拒绝");

        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS,ReturnMsg.PASS);
    }

    @Override
    public ResponseResult revoke(HandleDataDTO handleDataDTO) {
        SysUser StartUser=new SysUser();
        if (handleDataDTO.getCurrentUserInfo().getUserId()!=null)//优先拿接口中的信息，方便调试
        {
            StartUser = sysUserService.getById(handleDataDTO.getCurrentUserInfo().getUserId());

        }
        else
        {
            StartUser= sysUserService.getById(LoginContext.getContext().getLoginUser());
        }
        Authentication.setAuthenticatedUserId(StartUser.getUserId().toString());
        List<AttachmentDTO> attachments = handleDataDTO.getAttachments();
        String comments = handleDataDTO.getComments();
        JSONObject formData = handleDataDTO.getFormData();
        String taskId = handleDataDTO.getTaskId();
        HistoricTaskInstance task = historyService.createHistoricTaskInstanceQuery().taskId(taskId).singleResult();
        Map<String,Object> map=new HashMap<>();
        if(formData!=null &&formData.size()>0){
            Map formValue = JSONObject.parseObject(formData.toJSONString(), new TypeReference<Map>() {
            });
            map.putAll(formValue);
            map.put(FORM_VAR,formData);
        }
        map.put(PROCESS_STATUS,BUSINESS_STATUS_2);
        taskService.setVariableLocal(taskId,"taskStatusWrapper", TASK_STATUS_3);//设置节点中的当前操作
        runtimeService.setVariables(task.getProcessInstanceId(),map);
        if(StringUtils.isNotBlank(comments)){
            taskService.addComment(task.getId(),task.getProcessInstanceId(),"opinion",comments);
        }
        if(attachments!=null && attachments.size()>0){
            for (AttachmentDTO attachment : attachments) {
                taskService.createAttachment("option",taskId,task.getProcessInstanceId(),attachment.getName(),attachment.getName(),attachment.getUrl());
            }
        }

        if(StringUtils.isNotBlank(handleDataDTO.getSignInfo())){
            taskService.addComment(task.getId(),task.getProcessInstanceId(),"sign",handleDataDTO.getSignInfo());
        }
        runtimeService.deleteProcessInstance(task.getProcessInstanceId(),"撤销");
        return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS,"");
    }

    @Override
    public PageResult<TaskVO> toDoList(TaskDTO taskDTO) {
        SysUser StartUser=new SysUser();
        if (taskDTO.getCurrentUserInfo().getUserId()!=null)//优先拿接口中的信息，方便调试
        {
            StartUser = sysUserService.getById(taskDTO.getCurrentUserInfo().getUserId());

        }
        else
        {
            StartUser= sysUserService.getById(LoginContext.getContext().getLoginUser());
        }
        TaskQuery taskQuery = taskService.createTaskQuery().taskAssignee(StartUser.getUserId().toString())
                .includeProcessVariables()
                .orderByTaskCreateTime().desc();
        //条件查询（流程名称，开始时间，结束时间,发物单位，装备名称）
        if (ObjectUtil.isNotNull(taskDTO.getProcessDefinitionName()) && ! taskDTO.getProcessDefinitionName().trim().isEmpty()){
            taskQuery = taskQuery.processDefinitionNameLike("%"+taskDTO.getProcessDefinitionName()+"%");
        }
        //装备名称
        if (ObjectUtil.isNotNull(taskDTO.getTypeName()) && ! taskDTO.getTypeName().trim().isEmpty()){
            taskQuery=taskQuery.processVariableValueLike(INVLIST,"%"+taskDTO.getTypeName()+"%");
        }
        //发物单位
        if (ObjectUtil.isNotNull(taskDTO.getStartOrgName()) && ! taskDTO.getStartOrgName().trim().isEmpty()){
            taskQuery = taskQuery.processVariableValueLike(START_ORG_NAME,"%"+taskDTO.getStartOrgName()+"%");
        }
        if (ObjectUtil.isNotNull(taskDTO.getEndOrgName()) && ! taskDTO.getEndOrgName().trim().isEmpty()){
            taskQuery = taskQuery.processVariableValueLike(END_ORG_NAME,"%"+taskDTO.getEndOrgName()+"%");
        }
        //流程状态
        if (ObjectUtil.isNotNull(taskDTO.getBusinessStatus()) && taskDTO.getBusinessStatus().equals("正在处理")){
            taskQuery=taskQuery.processVariableValueEquals(PROCESS_STATUS,taskDTO.getBusinessStatus());
        }else if (ObjectUtil.isNotNull(taskDTO.getBusinessStatus()) && taskDTO.getBusinessStatus().equals("撤销")){
            taskQuery=taskQuery.processVariableValueEquals(PROCESS_STATUS,taskDTO.getBusinessStatus());
        }else if (ObjectUtil.isNotNull(taskDTO.getBusinessStatus()) && taskDTO.getBusinessStatus().equals("驳回")){
            taskQuery=taskQuery.processVariableValueEquals(PROCESS_STATUS,taskDTO.getBusinessStatus());
        }else if (ObjectUtil.isNotNull(taskDTO.getBusinessStatus()) && taskDTO.getBusinessStatus().equals("已结束")){
            taskQuery=taskQuery.processVariableValueEquals(PROCESS_STATUS,taskDTO.getBusinessStatus());
        }

//        //开始时间
//        if (ObjectUtil.isNotNull(taskDTO.getStartTime())) {
//            taskQuery = taskQuery.taskCreatedAfter(taskDTO.getStartTime());
//            taskQuery.taskDueAfter(taskDTO.getStartTime());
//
//        }
//        //结束时间
//        if (ObjectUtil.isNotNull(taskDTO.getEndTime())){
//            taskQuery=taskQuery.taskCreatedBefore(taskDTO.getEndTime());
//            taskQuery.taskDueBefore(taskDTO.getEndTime());
//        }
        List<Task> tasks = taskQuery.listPage((taskDTO.getPageNo() - 1) * taskDTO.getPageSize(), taskDTO.getPageSize());
        //根据条件查询符合条件的数据并统计数量条数
        long count = taskQuery.count();
//        long count = taskService.createTaskQuery().taskAssignee(StartUser.getUserId().toString()).count();
        List<TaskVO> taskVOS= new ArrayList<>();
        Page<TaskVO> page =new Page<>();
        for (Task task : tasks) {
            ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();

            BpmnModel bpmnModel = repositoryService.getBpmnModel(task.getProcessDefinitionId());
            Map<String, Object> processVariables = task.getProcessVariables();
            TaskVO taskVO=new TaskVO();
            taskVO.setTaskId(task.getId());
            taskVO.setProcessInstanceId(task.getProcessInstanceId());
            taskVO.setProcessDefinitionName(bpmnModel.getMainProcess().getName());
//            taskVO.setStartUser(JSONObject.parseObject(MapUtil.getStr(processVariables, START_USER_INFO), new TypeReference<ProcessUser>() {
//            }).getUserInfo());
            String s = (String) processVariables.get(START_USER_INFO);
            taskVO.setStartUser(JSONObject.parseObject(s, UserInfo.class));

            taskVO.setOrderId(MapUtil.getStr(processVariables, ORDER_ID));
            taskVO.setOrderType(MapUtil.getStr(processVariables, ORDER_TYPE));
            taskVO.setStartTime(processInstance.getStartTime());
            taskVO.setCurrentActivityName(getCurrentName(processInstance.getId(),false,processInstance.getProcessDefinitionId()));

            taskVO.setBusinessStatus(MapUtil.getStr(processVariables,PROCESS_STATUS));

            taskVO.setStartOrgName(MapUtil.getStr(processVariables,START_ORG_NAME));
            taskVO.setEndOrgName(MapUtil.getStr(processVariables,END_ORG_NAME));
            taskVO.setInvList(MapUtil.getStr(processVariables,INVLIST));
            taskVO.setBusinessType(MapUtil.getStr(processVariables,BUSSINESS_TYPE));
            taskVO.setOutInState(MapUtil.getStr(processVariables,OUT_IN_STATE));


            taskVO.setTaskCreatedTime(task.getCreateTime());
            DelegationState delegationState = task.getDelegationState();
            if(delegationState!=null){
                taskVO.setDelegationState(delegationState);
            }
            taskVOS.add(taskVO);
        }

        page.setRecords(taskVOS);
        page.setTotal(count);
        page.setCurrent(taskDTO.getPageNo());
        page.setSize(taskDTO.getPageSize());
        return PageResultFactory.createPageResult(page);
    }

    @Override
    public PageResult<TaskVO> doneList(TaskDTO taskDTO) {
        SysUser StartUser=new SysUser();
        if (taskDTO.getCurrentUserInfo().getUserId()!=null)//优先拿接口中的信息，方便调试
        {
            StartUser = sysUserService.getById(taskDTO.getCurrentUserInfo().getUserId());
        }
        else
        {
            StartUser= sysUserService.getById(LoginContext.getContext().getLoginUser());
        }
        HistoricTaskInstanceQuery historicTaskQuery  = historyService.createHistoricTaskInstanceQuery()
                .taskAssignee(StartUser.getUserId().toString())
                .finished()
                .includeCaseVariables().includeProcessVariables().includeTaskLocalVariables().includeIdentityLinks()
                .orderByTaskCreateTime().desc();

        //根据条件查询（流程名称，开始时间，结束时间）
        if (ObjectUtil.isNotNull(taskDTO.getProcessDefinitionName()) && ! taskDTO.getProcessDefinitionName().trim().isEmpty()){
            historicTaskQuery = historicTaskQuery.processDefinitionNameLike("%"+taskDTO.getProcessDefinitionName()+"%");
        }
        //开始时间
//        if (ObjectUtil.isNotNull(taskDTO.getStartTime())) {
//            historicTaskQuery = historicTaskQuery.taskCompletedAfter(taskDTO.getStartTime());
//
//        }
//        //结束时间
//        if (ObjectUtil.isNotNull(taskDTO.getEndTime())){
//            historicTaskQuery = historicTaskQuery.taskCompletedAfter(taskDTO.getEndTime());
//        }
        //装备名称
        if (ObjectUtil.isNotNull(taskDTO.getTypeName()) && ! taskDTO.getTypeName().trim().isEmpty()){
            historicTaskQuery=historicTaskQuery.processVariableValueLike(INVLIST,"%"+taskDTO.getTypeName()+"%");

        }
        //发物单位
        if (ObjectUtil.isNotNull(taskDTO.getStartOrgName()) && ! taskDTO.getStartOrgName().trim().isEmpty()){
            historicTaskQuery = historicTaskQuery.processVariableValueLike(START_ORG_NAME,"%"+taskDTO.getStartOrgName()+"%");
        }

        if (ObjectUtil.isNotNull(taskDTO.getEndOrgName()) && ! taskDTO.getEndOrgName().trim().isEmpty()){
            historicTaskQuery = historicTaskQuery.processVariableValueLike(END_ORG_NAME,"%"+taskDTO.getEndOrgName()+"%");
        }
        //流程状态
        if (ObjectUtil.isNotNull(taskDTO.getBusinessStatus()) && taskDTO.getBusinessStatus().equals("正在处理")){
            historicTaskQuery=historicTaskQuery.processVariableValueEquals(PROCESS_STATUS,taskDTO.getBusinessStatus());
        }else if (ObjectUtil.isNotNull(taskDTO.getBusinessStatus()) && taskDTO.getBusinessStatus().equals("撤销")){
            historicTaskQuery=historicTaskQuery.processVariableValueEquals(PROCESS_STATUS,taskDTO.getBusinessStatus());
        }else if (ObjectUtil.isNotNull(taskDTO.getBusinessStatus()) && taskDTO.getBusinessStatus().equals("驳回")){
            historicTaskQuery=historicTaskQuery.processVariableValueEquals(PROCESS_STATUS,taskDTO.getBusinessStatus());
        }else if (ObjectUtil.isNotNull(taskDTO.getBusinessStatus()) && taskDTO.getBusinessStatus().equals("已结束")){
            historicTaskQuery=historicTaskQuery.processVariableValueEquals(PROCESS_STATUS,taskDTO.getBusinessStatus());
        }
//        List<HistoricTaskInstance> tasks = historicTaskQuery.list();
        List<HistoricTaskInstance> tasks = historicTaskQuery.listPage((taskDTO.getPageNo() - 1) * taskDTO.getPageSize(), taskDTO.getPageSize());
        long count = historicTaskQuery.count();
//        long count = historyService.createHistoricTaskInstanceQuery()
//                .taskAssignee(StartUser.getUserId().toString()).count();
        List<TaskVO> taskVOS = new ArrayList<>();
        Page<TaskVO> page = new Page<>();
        for (HistoricTaskInstance task : tasks) {
            HistoricProcessInstance historicProcessInstance = historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            Boolean flag = historicProcessInstance.getEndTime() == null ? false : true;

            BpmnModel bpmnModel = null;
            try {
                bpmnModel = repositoryService.getBpmnModel(task.getProcessDefinitionId());
            } catch (Exception e) {
                // 处理获取BpmnModel异常的情况
                e.printStackTrace(); // 可以将异常信息打印到日志中
                // 可以在这里设置默认的BpmnModel或采取其他处理措施
            }

            Map<String, Object> processVariables = task.getProcessVariables();
            TaskVO taskVO = new TaskVO();
            taskVO.setTaskId(task.getId());
            taskVO.setProcessInstanceId(task.getProcessInstanceId());
            if (bpmnModel!=null)
            {
                taskVO.setProcessDefinitionName(bpmnModel.getMainProcess().getName());
            }
//            taskVO.setStartUser(JSONObject.parseObject(MapUtil.getStr(processVariables, START_USER_INFO), new TypeReference<ProcessUser>() {
//            }).getUserInfo());
            String s = (String) processVariables.get(START_USER_INFO);
            taskVO.setStartUser(JSONObject.parseObject(s, UserInfo.class));

            taskVO.setOrderId(MapUtil.getStr(processVariables, ORDER_ID));
            taskVO.setOrderType(MapUtil.getStr(processVariables, ORDER_TYPE));
            taskVO.setStartTime(historicProcessInstance.getStartTime());
            taskVO.setCurrentActivityName(getCurrentName(task.getProcessInstanceId(), flag, task.getProcessDefinitionId()));
            taskVO.setBusinessStatus(MapUtil.getStr(processVariables, PROCESS_STATUS));
            taskVO.setEndTime(task.getEndTime());

            taskVO.setStartOrgName(MapUtil.getStr(processVariables,START_ORG_NAME));
            taskVO.setEndOrgName(MapUtil.getStr(processVariables,END_ORG_NAME));
            taskVO.setInvList(MapUtil.getStr(processVariables,INVLIST));
            taskVO.setBusinessType(MapUtil.getStr(processVariables,BUSSINESS_TYPE));
            taskVO.setOutInState(MapUtil.getStr(processVariables,OUT_IN_STATE));

            long totalTimes = task.getEndTime() == null ?
                    (Calendar.getInstance().getTimeInMillis() - task.getStartTime().getTime()) :
                    (task.getEndTime().getTime() - task.getStartTime().getTime());
            long dayCount = totalTimes / (1000 * 60 * 60 * 24);//计算天
            long restTimes = totalTimes % (1000 * 60 * 60 * 24);//剩下的时间用于计于小时
            long hourCount = restTimes / (1000 * 60 * 60);//小时
            restTimes = restTimes % (1000 * 60 * 60);
            long minuteCount = restTimes / (1000 * 60);
            String spendTimes = dayCount + "天" + hourCount + "小时" + minuteCount + "分";
            taskVO.setDuration(spendTimes);
            taskVOS.add(taskVO);
        }

        page.setRecords(taskVOS);
        page.setCurrent(taskDTO.getPageNo());
        page.setSize(taskDTO.getPageSize());
        page.setTotal(count);

        return PageResultFactory.createPageResult(page);
    }

    @Override
    public PageResult<HistoryProcessInstanceVO> applyList(ApplyDTO applyDTO) {
        SysUser StartUser=new SysUser();
        if (applyDTO.getCurrentUserInfo().getUserId()!=null)//优先拿接口中的信息，方便调试
        {
            StartUser = sysUserService.getById(applyDTO.getCurrentUserInfo().getUserId());
        }
        else
        {
            StartUser= sysUserService.getById(LoginContext.getContext().getLoginUser());
        }
        PageResult<HistoryProcessInstanceVO> pageResult=new  PageResult<HistoryProcessInstanceVO>();
        HistoricProcessInstanceQuery desc = historyService.createHistoricProcessInstanceQuery()
                .includeProcessVariables()
                .startedBy(StartUser.getUserId().toString())
                .orderByProcessInstanceStartTime().desc();
        //根据条件查询（流程名称，开始时间，结束时间）
        if (ObjectUtil.isNotNull(applyDTO.getProcessDefinitionName()) && ! applyDTO.getProcessDefinitionName().trim().isEmpty()){
            List<ProcessDefinition> processDefinitions = repositoryService.createProcessDefinitionQuery()
                    .processDefinitionNameLike("%" + applyDTO.getProcessDefinitionName() + "%")
                    .list();

            List<String> processDefinitionKeys = processDefinitions.stream()
                    .map(ProcessDefinition::getKey)
                    .collect(Collectors.toList());

            desc.processDefinitionKeyIn(processDefinitionKeys);
        }
        if (ObjectUtil.isNotNull(applyDTO.getStartTime())) {
            desc = desc.startedAfter(applyDTO.getStartTime());
        }
        if (ObjectUtil.isNotNull(applyDTO.getEndTime())) {
            desc = desc.startedBefore(applyDTO.getEndTime());
        }
        //装备名称
        if (ObjectUtil.isNotNull(applyDTO.getTypeName()) && ! applyDTO.getTypeName().trim().isEmpty()){
            desc=desc.variableValueLike(INVLIST,"%"+applyDTO.getTypeName()+"%");
        }
        //发物单位
        if (ObjectUtil.isNotNull(applyDTO.getStartOrgName()) && ! applyDTO.getStartOrgName().trim().isEmpty()){
            desc = desc.variableValueLike(START_ORG_NAME,"%"+applyDTO.getStartOrgName()+"%");
        }
        if (ObjectUtil.isNotNull(applyDTO.getEndOrgName()) && ! applyDTO.getEndOrgName().trim().isEmpty()){
            desc = desc.variableValueLike(END_ORG_NAME,"%"+applyDTO.getEndOrgName()+"%");
        }
        //流程状态
        if (ObjectUtil.isNotNull(applyDTO.getBusinessStatus()) && applyDTO.getBusinessStatus().equals("正在处理")){
            desc=desc.variableValueEquals(PROCESS_STATUS,applyDTO.getBusinessStatus());
        }else if (ObjectUtil.isNotNull(applyDTO.getBusinessStatus()) && applyDTO.getBusinessStatus().equals("撤销")){
            desc=desc.variableValueEquals(PROCESS_STATUS,applyDTO.getBusinessStatus());
        }else if (ObjectUtil.isNotNull(applyDTO.getBusinessStatus()) && applyDTO.getBusinessStatus().equals("驳回")){
            desc=desc.variableValueEquals(PROCESS_STATUS,applyDTO.getBusinessStatus());
        }else if (ObjectUtil.isNotNull(applyDTO.getBusinessStatus()) && applyDTO.getBusinessStatus().equals("已结束")){
            desc=desc.variableValueEquals(PROCESS_STATUS,applyDTO.getBusinessStatus());
        }

        List<HistoricProcessInstance> historicProcessInstances = desc.listPage((applyDTO.getPageNo() - 1) * applyDTO.getPageSize(), applyDTO.getPageSize());
        long count = desc.count();
//        long count = historyService.createHistoricProcessInstanceQuery()
//                .startedBy(StartUser.getUserId().toString()).count();
        List<HistoryProcessInstanceVO> historyProcessInstanceVOS = new ArrayList<>();
        Page<HistoryProcessInstanceVO> page = new Page<>();
        for (HistoricProcessInstance historicProcessInstance : historicProcessInstances) {
            Map<String, Object> processVariables = historicProcessInstance.getProcessVariables();
            HistoryProcessInstanceVO historyProcessInstanceVO = new HistoryProcessInstanceVO();
            historyProcessInstanceVO.setProcessInstanceId(historicProcessInstance.getId());

            BpmnModel bpmnModel = repositoryService.getBpmnModel(historicProcessInstance.getProcessDefinitionId());

            String Name= bpmnModel.getMainProcess().getName();
            historyProcessInstanceVO.setOrderId(MapUtil.getStr(processVariables, ORDER_ID));
            historyProcessInstanceVO.setOrderType(MapUtil.getStr(processVariables, ORDER_TYPE));
            historyProcessInstanceVO.setProcessDefinitionName(historicProcessInstance.getProcessDefinitionName());
//            historyProcessInstanceVO.setStartUser(JSONObject.parseObject(MapUtil.getStr(processVariables, START_USER_INFO), new TypeReference<ProcessUser>() {
//            }).getUserInfo());
            String s = (String) processVariables.get(START_USER_INFO);
            historyProcessInstanceVO.setStartUser(JSONObject.parseObject(s, UserInfo.class));

            historyProcessInstanceVO.setStartTime(historicProcessInstance.getStartTime());
            historyProcessInstanceVO.setEndTime(historicProcessInstance.getEndTime());
            Boolean flag = historicProcessInstance.getEndTime() == null ? false : true;
            historyProcessInstanceVO.setCurrentActivityName(getCurrentName(historicProcessInstance.getId(), flag, historicProcessInstance.getProcessDefinitionId()));
            historyProcessInstanceVO.setBusinessStatus(MapUtil.getStr(processVariables, PROCESS_STATUS));

            historyProcessInstanceVO.setStartOrgName(MapUtil.getStr(processVariables,START_ORG_NAME));
            historyProcessInstanceVO.setEndOrgName(MapUtil.getStr(processVariables,END_ORG_NAME));
            historyProcessInstanceVO.setInvList(MapUtil.getStr(processVariables,INVLIST));
            historyProcessInstanceVO.setBussinessType(MapUtil.getStr(processVariables,BUSSINESS_TYPE));
            historyProcessInstanceVO.setOutInState(MapUtil.getStr(processVariables,OUT_IN_STATE));

            long totalTimes = historicProcessInstance.getEndTime() == null ?
                    (Calendar.getInstance().getTimeInMillis() - historicProcessInstance.getStartTime().getTime()) :
                    (historicProcessInstance.getEndTime().getTime() - historicProcessInstance.getStartTime().getTime());
            long dayCount = totalTimes / (1000 * 60 * 60 * 24);//计算天
            long restTimes = totalTimes % (1000 * 60 * 60 * 24);//剩下的时间用于计于小时
            long hourCount = restTimes / (1000 * 60 * 60);//小时
            restTimes = restTimes % (1000 * 60 * 60);
            long minuteCount = restTimes / (1000 * 60);

            String spendTimes = dayCount + "天" + hourCount + "小时" + minuteCount + "分";
            historyProcessInstanceVO.setDuration(spendTimes);
            historyProcessInstanceVOS.add(historyProcessInstanceVO);
        }
        pageResult.setRecords(historyProcessInstanceVOS);
//        pageResult.setTotalRows(Long.valueOf(applyDTO.getPageNo()));
        pageResult.setTotalRows(count);
        pageResult.setTotalPage(PageUtil.totalPage((int) count, Convert.toInt(pageResult.getPageSize())));
        pageResult.setPageSize(Long.valueOf(applyDTO.getPageSize()));
        pageResult.setPageNo(Long.valueOf(applyDTO.getPageNo()));
        return  pageResult;
    }

    @Override
    public ApiRes<RecordVO> record(String processInstanceId) {
        RecordVO vo=new RecordVO();
        String tempID= flowInstanceService.getFormIdByInstanceId(processInstanceId);//先拿到表单id，然后通过表单拿到初始表结构
        ProcessTemplates processTemplates = processTemplateService.getById(tempID);
        Object formJson= processTemplates.getProcessJson();

        List<Comment> processInstanceComments = taskService.getProcessInstanceComments(processInstanceId);

        HistoricProcessInstance historicProcessInstance = historyService.createHistoricProcessInstanceQuery()
                .processInstanceId(processInstanceId)
                .singleResult();
            String deployId = historicProcessInstance.getDeploymentId();
        Map<String, Object> result= Test(processInstanceId,deployId);
        vo.setResult(result);
        Map<String, List<Comment>> commentsMap = processInstanceComments.stream()
                .collect(Collectors.groupingBy(Comment::getTaskId, Collectors.toList()));
        List<Attachment> processInstanceAttachments = taskService.getProcessInstanceAttachments(processInstanceId);
        Map<String, List<Attachment>> attachmentMap = processInstanceAttachments.stream()
                .collect(Collectors.groupingBy(Attachment::getTaskId));
        List<HistoricActivityInstance> list = historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceStartTime().asc().list();
        List<TaskDetailVO> taskDetailVOS= new ArrayList<>();
        String userStart = historicProcessInstance.getStartUserId();

//                    taskDetailVO.setUserId(user.getUserId().toString());

        for (HistoricActivityInstance historicActivityInstance : list) {
            if("startEvent".equals(historicActivityInstance.getActivityType())){

                TaskDetailVO taskDetailVO= new TaskDetailVO();
                taskDetailVO.setTaskId(historicActivityInstance.getTaskId());
                taskDetailVO.setActivityId(historicActivityInstance.getActivityId());
                taskDetailVO.setName("发起人");
                taskDetailVO.setTaskStatusWrapper("发起");
//                taskDetailVO.setUserId(JSONObject.parseObject(userStart, UserInfo.class).getUserId().toString());
//                taskDetailVO.setUserName(JSONObject.parseObject(userStart, UserInfo.class).getRealName().toString());

                taskDetailVO.setCreateTime(historicActivityInstance.getStartTime());
                taskDetailVO.setEndTime(historicActivityInstance.getEndTime());
                if (userStart!=null||!userStart.isEmpty())
                {
                    SysUser user=   sysUserService.getById(userStart);
                    taskDetailVO.setUserId(user.getUserId().toString());
                    taskDetailVO.setUserName(user.getRealName());
                }

                taskDetailVOS.add(taskDetailVO);

            }
            else if("endEvent".equals(historicActivityInstance.getActivityType())){
                TaskDetailVO taskDetailVO= new TaskDetailVO();
                taskDetailVO.setTaskId(historicActivityInstance.getTaskId());
                taskDetailVO.setActivityId(historicActivityInstance.getActivityId());
                taskDetailVO.setName("流程结束");
                taskDetailVO.setTaskStatusWrapper("结束");
                taskDetailVO.setCreateTime(historicActivityInstance.getStartTime());
                taskDetailVO.setEndTime(historicActivityInstance.getEndTime());


                taskDetailVOS.add(taskDetailVO);
            }
            else if("userTask".equals(historicActivityInstance.getActivityType())){
                List<Comment> comments = commentsMap.get(historicActivityInstance.getTaskId());

                if(CollUtil.isNotEmpty(comments)){
                    for (Comment comment : comments) {
                        if("opinion".equals(comment.getType())){
                            TaskDetailVO taskDetailVO= new TaskDetailVO();
                            taskDetailVO.setTaskId(historicActivityInstance.getTaskId());
                            List<HistoricVariableInstance> taskStatusWrapper = historyService.createHistoricVariableInstanceQuery().taskId(historicActivityInstance.getTaskId()).list();

                            if (taskStatusWrapper.size()>0)
                            {
                                taskDetailVO.setTaskStatusWrapper(taskStatusWrapper.get(0).getValue().toString());
                            }
                            if (historicActivityInstance.getAssignee()!=null)
                            {
                                SysUser user=   sysUserService.getById(historicActivityInstance.getAssignee());
                                taskDetailVO.setUserId(user.getUserId().toString());
                                taskDetailVO.setUserName(user.getRealName());}
                            taskDetailVO.setActivityId(historicActivityInstance.getActivityId());
                            taskDetailVO.setName(historicActivityInstance.getActivityName());
                            taskDetailVO.setCreateTime(historicActivityInstance.getStartTime());
                            taskDetailVO.setEndTime(historicActivityInstance.getEndTime());
                            List<Attachment> attachments = attachmentMap.get(historicActivityInstance.getTaskId());
                            List<AttachmentVO> attachmentVOList = new ArrayList<>();

                            if (attachments!=null)
                            {
                                for (Attachment attachment : attachments) {
                                    AttachmentVO attachmentVO = new AttachmentVO();
                                    attachmentVO.setId(attachment.getId());
                                    attachmentVO.setName(attachment.getName());
                                    attachmentVO.setUrl(attachment.getUrl());
                                    attachmentVOList.add(attachmentVO);
                                }
                            }


                            for (Comment comment1 : comments) {
                                if("sign".equals(comment1.getType())){
                                    taskDetailVO.setSignImage(comment1.getFullMessage());
                                }
                            }
                            taskDetailVO.setComment(new String(comments.get(0).getFullMessage().getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8));
                            taskDetailVO.setAttachmentVOList(attachmentVOList);
                            taskDetailVOS.add(taskDetailVO);
                        }
                    }
                }
            }


        }
        // 查询流程定义信息
        ProcessDefinition processDefinition = repositoryService.createProcessDefinitionQuery()
                .deploymentId(deployId)
                .singleResult();

        // 获取所有任务节点信息
        BpmnModel bpmnModel = repositoryService.getBpmnModel(processDefinition.getId());
        Collection<FlowElement> flowElements = bpmnModel.getMainProcess().getFlowElements();

        // 遍历所有任务节点和结束节点，如果不在已有任务列表中，则添加到结果中
        for (FlowElement flowElement : flowElements) {
            Object aa=flowElement.getId().toString();
            if (flowElement instanceof UserTask && !flowElement.getId().toString().equals("root")&&
                    !taskDetailVOS.stream().anyMatch(task -> task.getActivityId().equals(flowElement.getId()))) {
                TaskDetailVO taskDetailVO = new TaskDetailVO();
                taskDetailVO.setActivityId(flowElement.getId());
                taskDetailVO.setName(flowElement.getName());
                // 其他属性的设置，根据需要进行修改

                // 将任务节点或结束节点添加到结果列表
                taskDetailVOS.add(taskDetailVO);
            }
        }
        // 根据 processInstanceId 查询正在执行的任务
        List<Task> list1 = taskService.createTaskQuery()
                .processInstanceId(processInstanceId)
                .list();
        if (list1.size()>0) {
            Task currentTask =list1.get(0);
            // 使用 Stream API 进行过滤和修改
            taskDetailVOS.stream()
                    .filter(taskDetail -> taskDetail.getActivityId().equals(currentTask.getTaskDefinitionKey()))
                    .findFirst()
                    .ifPresent(matchingTask -> matchingTask.setTaskStatusWrapper("待审核"));
        }

        JSONObject jsonForm = JSON.parseObject(formJson.toString());

        JSONArray jsonArray2 = new JSONArray(Collections.singletonList(taskDetailVOS));
        JSONObject formJsonObj= matchAndMergeData(jsonForm,jsonArray2);
        vo.setFormJson(formJsonObj);
        vo.setTaskVo(taskDetailVOS);
        return ApiRes.success(vo);
    }

    private static JSONObject  matchAndMergeData(JSONObject data1, JSONArray data2) {
        if (data1.containsKey("id") && data1.containsKey("childNode")) {
            String id1 = data1.getString("id");
            // 获取第一条数据
            JSONArray jsonArray = data2.getJSONArray(0);
            // 查找匹配的数据
            TaskDetailVO matchingData = jsonArray.stream()
                    .filter(item -> item instanceof TaskDetailVO)
                    .map(item -> (TaskDetailVO) item)
                    .filter(item -> id1.equals(removeNodePrefix(item.getActivityId())))
                    .findFirst()
                    .orElse(null);
            // 如果找到匹配的数据，则将匹配的值设置到 data1 中
            if (matchingData != null) {
                if (matchingData.getTaskStatusWrapper()==null)
                {
                    data1.put("status", "未进行");
                }
                else
                {
                    data1.put("status", matchingData.getTaskStatusWrapper());
                }

            }

            // 递归处理子节点
            if (data1.containsKey("childNode") && data1.get("childNode") instanceof JSONObject) {
                matchAndMergeData(data1.getJSONObject("childNode"), data2);
            }

        }
        return data1;
    }
    private static String removeNodePrefix(String activityId) {
        // 移除前缀"Node_"
        return activityId.startsWith("Node_") ? activityId.substring(5) : activityId;
    }






private  Map<String, Object>  Test(String procInsId,String deployId)
{
    try {
    List<FlowViewerDto> flowViewerList = new ArrayList<>();
    // 获取已经完成的节点
    List<HistoricActivityInstance> listFinished = historyService.createHistoricActivityInstanceQuery()
            .processInstanceId(procInsId)
            .finished()
            .list();

    // 保存已经完成的流程节点编号
    listFinished.forEach(s -> {
        FlowViewerDto flowViewerDto = new FlowViewerDto();
        flowViewerDto.setKey(s.getActivityId());
        flowViewerDto.setCompleted(true);
        flowViewerList.add(flowViewerDto);
    });

    // 获取代办节点
    List<HistoricActivityInstance> listUnFinished = historyService.createHistoricActivityInstanceQuery()
            .processInstanceId(procInsId)
            .unfinished()
            .list();

    // 保存需要代办的节点编号
    listUnFinished.forEach(s -> {
        FlowViewerDto flowViewerDto = new FlowViewerDto();
        flowViewerDto.setKey(s.getActivityId());
        flowViewerDto.setCompleted(false);
        flowViewerList.add(flowViewerDto);
    });
    Map<String, Object> result = new HashMap();
    // xmlData 数据
    ProcessDefinition definition = repositoryService.createProcessDefinitionQuery().deploymentId(deployId).singleResult();
    InputStream inputStream = repositoryService.getResourceAsStream(definition.getDeploymentId(), definition.getResourceName());
    String xmlData = IOUtils.toString(inputStream, StandardCharsets.UTF_8);
    result.put("nodeData", flowViewerList);
    result.put("xmlData", xmlData);
    return  result;
    } catch (Exception e) {
return  null;
    }
}

    /**
     * @Author: Zhaojw
     * @Description: 为用户赋值
     * @DateTime: 2023/9/27 16:00
     * @Params:
     * @Return
     */
    private UserInfo SetUser(SysUser sysUser)
    {
        UserInfo userInfo=new UserInfo();
        userInfo.setUserId(sysUser.getUserId());
        userInfo.setId(sysUser.getUserId().toString());
        userInfo.setName(sysUser.getRealName());
        userInfo.setSex(sysUser.getSex());
        return  userInfo;
    }
    private String getCurrentName(String processInstanceId, Boolean flag, String processDefinitionId) {
        if (flag) {
            return "流程已结束";
        }
        List<ActivityInstance> list = runtimeService.createActivityInstanceQuery().processInstanceId(processInstanceId).activityType("userTask").unfinished().orderByActivityInstanceStartTime().desc().list();
        if(CollUtil.isEmpty(list)){
            return "";
        }
        else{
            String activityId = list.get(0).getActivityId();
            BpmnModel bpmnModel = repositoryService.getBpmnModel(processDefinitionId);
            FlowElement flowElement = bpmnModel.getMainProcess().getFlowElement(activityId);
            return flowElement.getName();
        }
//        Execution execution = runtimeService.createExecutionQuery().executionId(processInstanceId).singleResult();
//        String activityId = execution.getActivityId();
//        if (StringUtils.isBlank(activityId)) {
//            return "";
//        } else {
//            BpmnModel bpmnModel = repositoryService.getBpmnModel(processDefinitionId);
//            FlowElement flowElement = bpmnModel.getMainProcess().getFlowElement(activityId);
//            return flowElement.getName();
//        }

    }
}
