package com.junmp.jyzb.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;

import java.time.Instant;

/**
 * 定义统一的返回类
 * */
@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ResponseResult<T> {

    /**
     * 状态码
     */
    private Integer code;

    /**
     * 提示信息，如果有错误时，前端可以获取该字段进行提示
     */
    private String message;

    /**
     * 查询到的结果数据，
     */
    private T data;

    /**
     * 时间戳
     */
    private long timestamp;

    public ResponseResult(Integer code, String message) {
        this.code = code;
        this.message = message;
        this.timestamp = generateTimestamp();
    }

    public ResponseResult(Integer code, T data) {
        this.code = code;
        this.data = data;
        this.timestamp = generateTimestamp();
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMsg(String msg) {
        this.message = msg;
    }

    public T getData() {
        return data;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setData(T data) {
        this.data = data;
    }

    public ResponseResult(Integer code, String msg, T data) {
        this.code = code;
        this.message = msg;
        this.data = data;
        this.timestamp = generateTimestamp();
    }

    //生成时间戳函数
    private long generateTimestamp() {
        return Instant.now().toEpochMilli();
    }
}
