package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <pre>
 *
 * 描述：业务单位信息
 * 版本：1.0.0
 * 日期：2022/7/29 16:42
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Data
@TableName("biz_company")
public class Company implements Serializable {

    /**
     * 企业编号
     */
    @TableId(value = "biz_id", type = IdType.AUTO)
    private Long bizId;

    /**
     * 当前序号
     */
    private Integer sn;

    /**
     * 企业编码
     */
    @TableField("biz_code")
    private String bizCode;

    /**
     * 企业类型
     */
    @TableField("biz_type")
    private String bizType;

    /**
     * 简称
     */
    @TableField("short_name")
    private String shortName;

    /**
     * 名称
     */
    private String name;

    private String remark;

    @TableField(fill = FieldFill.INSERT, value = "create_time")
    private Date createTime;

    @TableField(fill = FieldFill.UPDATE, value = "update_time")
    private Date updateTime;
}
