package com.junmp.jyzb.api.bean.req;
import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = true)
public class UpdateBusFormReq extends BaseRequest {

    /**
     * id
     */
    @NotBlank(message = "单据id不能为空",groups = {edit.class})
    private String id;

//    private String userId;
    /**
     * 工作流id
     */
    private String processDefinitionId;

    /**
     * 单据业务类型
     */
    @NotBlank(message = "业务单据类型不能为空",groups = {add.class,edit.class})
    private String bussinessType;

    /**
     * 单据编号
     */
    private String bussinessCode;

    /**
     * 组织机构id
     */
//    @NotNull(message = "组织机构id不能为空",groups = {add.class})
    private Long orgId;

    /**
     * 组织机构名称
     */
    private String orgName;

    /**
     * 发物单位id
     */
    private Long startOrgId;

    /**
     * 发物单位
     */
    private String startOrgName;
    /**
     * 收物单位id
     */
    private Long endOrgId;

    /**
     * 收物单位
     */
    private String endOrgName;

    /**
     * 审核状态
     */
    private String examineState;

    /**
     * 价格
     */
    private BigDecimal price;

    /**
     * 数量
     */
    private Integer inventoryQuantity;

    /**
     * 附件地址
     */
    private String attachmentLocation;

    private String agentId;
    /**
     * 经办人
     */
    private String agent;

    /**
     * 归还人id
     */
    private String returnUserId;

    /**
     * 归还人
     */
    private String returnUser;

    /**
     * 归还日期
     */
    private Date returnDate;

    /**
     * 申请时间
     */
    private Date applyTime;

    /**
     * 申请人
     */
    private String applyUser;

    /**
     * 申请人id
     */
    private String applyUserId;

    /**
     * 调拨类型（2支拨，1价拨）
     */
    private String allocateType;

    /**
     * 备注
     */
    private String note;

    /**
     * 厂商id
     */
    private String supplierId;

    /**
     * 厂商名称
     */
    private String supplierName;
    /**
     * 厂商类型（0为供应商，1为生产厂商，2为维修单位，3为销毁单位）
     */
    private Integer agencyType;
    /**
     * 仓库id
     */
    private String warehouseId;

    /**
     * 装备详情
     */
    private String detailList;


    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 报废销毁类型（1销毁出库，2移入报废区）
     */
    private Integer type;

    /**
     * 单据使用次数（forbidden禁止使用，outgoing 仅出库使用，incoming仅入库使用，bothuseing出入库都可以使用一次）
     */
    private String useCount;

    /**
     *装备类别拼接
     */
    private String invList;

}
