package com.junmp.jyzb.utils;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;

import java.util.List;

/**
 * 接口参数校验
 * */
public class CheckBlank {
    public static <T> void checkNotBlank(T value, String errorMsg) {
        // 如果value为null
        if (value == null) {
            throw new IllegalArgumentException(errorMsg);
        }

        // 如果value为字符串类型
        if (value instanceof String) {
            String strValue = (String) value;
            if (StringUtils.isBlank(strValue)) {
                throw new IllegalArgumentException(errorMsg);
            }
        }

        // 如果value为List类型
        if (value instanceof List) {
            List<?> listValue = (List<?>) value;
            if (listValue.isEmpty()) {
                throw new IllegalArgumentException(errorMsg);
            }
        }
    }
}
