package com.junmp.jyzb.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.dto.WarehouseDto;
import com.junmp.jyzb.api.bean.query.ProductReq;
import com.junmp.jyzb.api.bean.query.WarehouseReq;
import com.junmp.jyzb.api.bean.req.UpdateWarehouseReq;
import com.junmp.jyzb.api.exception.enums.WarehouseExceptionEnum;
import com.junmp.jyzb.entity.*;
import com.junmp.jyzb.api.exception.enums.CabinetExceptionEnum;
import com.junmp.jyzb.api.exception.enums.PubOrgExceptionEnum;
import com.junmp.jyzb.mapper.*;
import com.junmp.jyzb.service.PubOrgService;
import com.junmp.jyzb.service.WarehouseService;
import com.junmp.jyzb.utils.*;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

import java.util.*;

@Service
@Slf4j
public class WarehouseServiceImpl extends ServiceImpl<WarehouseMapper,Warehouse> implements WarehouseService {


    @Resource
    private WarehouseMapper warehouseMapper;

    @Resource
    private PubOrgService pubOrgService;



    @Override
    public String AddWarehouse(UpdateWarehouseReq req) {
        Warehouse warehouse = new Warehouse();
        BeanPlusUtil.copyProperties(req, warehouse);
        warehouse.setCreateTime(DateTimeUtil.getCurrentDateTime());
        warehouse.setUpdateTime(DateTimeUtil.getCurrentDateTime());
        save(warehouse);
        return warehouse.getId();
    }

    @Override
    public WarehouseDto getOneWarehouse(WarehouseReq req) {
        Warehouse warehouse = WarehoustExist(req.getId());
        WarehouseDto warehouseDto = new WarehouseDto();
        BeanPlusUtil.copyProperties(warehouse,warehouseDto);
        //获取组织机构名称
        PubOrg pubOrg = pubOrgService.PubOrgExist(warehouse.getOrgId());
        warehouseDto.setOrgName(pubOrg.getOrgName());
        return warehouseDto;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean DeleteWarehouse(UpdateWarehouseReq req) {
        if(ObjectUtil.isNull(req.getWarehouseList())||req.getWarehouseList().size()==0 ){
            throw new ServiceException(CabinetExceptionEnum.PARAMETER_ERROR);
        }
        List<String> warehouseList = req.getWarehouseList();
        for (String s:warehouseList) {
            if (s.equals("")){
                throw new ServiceException(CabinetExceptionEnum.PARAMETER_ERROR);
            }
        }
        return removeBatchByIds(warehouseList);
    }

    @Override
    public boolean updateWarehouse(UpdateWarehouseReq req) {
        Warehouse warehouse = new Warehouse();
        BeanPlusUtil.copyProperties(req,warehouse);
        warehouse.setUpdateTime(DateTimeUtil.getCurrentDateTime());
        return this.updateById(warehouse);
    }



    @Override
    public List<WarehouseDto> getAllWarehouse(Long orgId) {
        List<WarehouseDto> warehouseDtoList=new ArrayList<>();
        //判断组织机构是否存在
        PubOrg pubOrg = pubOrgService.PubOrgExist(orgId);
        //根据组织机构id查询组织机构名称
        String orgName = pubOrg.getOrgName();

        List<Warehouse> list = list(new LambdaQueryWrapper<Warehouse>()
                .eq(Warehouse::getOrgId, orgId));
        for (Warehouse warehouse:list) {
            WarehouseDto warehouseDto = new WarehouseDto();
            BeanPlusUtil.copyProperties(warehouse,warehouseDto);
            warehouseDto.setOrgName(orgName);
            warehouseDtoList.add(warehouseDto);
        }
        return warehouseDtoList;
    }


    private List<Long> getAllOrgId(WarehouseReq msg) {
        List<Long> allOrg = new ArrayList<>();
        if (msg.getIncludeLowerLevel().equals("false")){
            allOrg.add(msg.getOrgId());
        }else if(msg.getIncludeLowerLevel().equals("true")){
            //查询某组织机构的本级及下级
            allOrg = pubOrgService.getLowerOrg(msg.getOrgId());
        }
        return allOrg;
    }

    private List<Warehouse> getAllWarehouseByOrg(List<Long> allOrgId) {
        List<Warehouse> allWarehouse = new ArrayList<>();

        LambdaQueryWrapper<Warehouse> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(Warehouse::getOrgId, allOrgId);

        allWarehouse = warehouseMapper.selectList(queryWrapper);
        return allWarehouse;
    }



    @Override
    public boolean changeWarehouseState(WarehouseReq req) {
        Warehouse warehouse = this.queryWarehouse(req);
        BeanPlusUtil.copyProperties(req, warehouse);
        return this.updateById(warehouse);
    }




    private Warehouse queryWarehouse(WarehouseReq req) {
        Warehouse warehouse = WarehoustExist(req.getId());
        return warehouse;
    }

    //判断仓库是否存在
    @Override
    public Warehouse WarehoustExist(String id) {
        Warehouse warehouseMsg=this.getById(id);
        if (ObjectUtil.isNull(warehouseMsg)){
            throw new ServiceException(WarehouseExceptionEnum.WAREHOUSE_NOT_EXIST);
        }
        return warehouseMsg;
    }

    //设置仓库中的装备信息（在库数，总数，出库数，价格）
    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean SetInventoryInfo(String id) {
        //统计仓库总数，在库总数，出库总数，装备总价格
        warehouseMapper.SetInventoryInfo(id);
        return true;
    }

}
