package com.junmp.jyzb.service.impl;

import com.junmp.jyzb.api.bean.dto.TjOrgEqsDto;
import com.junmp.jyzb.entity.PubOrg;
import com.junmp.jyzb.mapper.PubOrgMapper;
import com.junmp.jyzb.service.PubOrgService;
import com.junmp.jyzb.service.TjService;
import com.junmp.v2.common.util.BeanPlusUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@Service
public class TjServiceImpl implements TjService {
    @Resource
    private PubOrgMapper pubOrgMapper;

    @Resource
    private PubOrgService pubOrgService;

    /**
     * 根据当前组织机构获取本级及下一级的组织机构
     * @param orgId
     * @return
     */

    public List<TjOrgEqsDto> showOrgList(Long orgId, boolean flag) {
        //返回结果列表
        List<TjOrgEqsDto> returnList=new ArrayList<>();

        //获取该组织机构其余几层的数据（除去下一层）
        List<TjOrgEqsDto> list2 =pubOrgMapper.getDownOrg(orgId);
        List<TjOrgEqsDto> compare2 = compare(list2);
        TjOrgEqsDto tjOrgEqsDto = new TjOrgEqsDto();

        PubOrg pubOrg = pubOrgService.getById(orgId);
        BeanPlusUtil.copyProperties(pubOrg,tjOrgEqsDto);
        if (flag){
            TjOrgEqsDto tjOrgEqsDto2 = new TjOrgEqsDto();
            BeanPlusUtil.copyProperties(pubOrg,tjOrgEqsDto2);
            compare2.add(0,tjOrgEqsDto2);
        }
        tjOrgEqsDto.setOrgNode(compare2);
        returnList.add(tjOrgEqsDto);

        //获取该组织机构下一层数据，仅限一层
        List<TjOrgEqsDto> list1 =pubOrgMapper.getLowOrg(orgId);
        List<TjOrgEqsDto> compare1 = compare(list1);
        if (flag){
            for (TjOrgEqsDto one:compare1) {
                List<TjOrgEqsDto> tjOrgEqsDtos = showOrgList(one.getOrgId(), false);
                one.setOrgNode(tjOrgEqsDtos);
            }
        }
        returnList.addAll(compare1);
        return returnList;
    }


    public List<TjOrgEqsDto> compare(List<TjOrgEqsDto> list){
        Comparator<TjOrgEqsDto> orgComparator = (value1, value2) -> {

            // 检查是否只包含数字
            boolean isValue1Numeric = value1.getOrgCode().matches("\\d+");
            boolean isValue2Numeric = value2.getOrgCode().matches("\\d+");

            if (isValue1Numeric && isValue2Numeric) {
                // 两个值都是纯数字，按照两位两位比较
                for (int i = 0; i < 12; i += 2) {
                    int digit1 = Integer.parseInt(value1.getOrgCode().substring(i, i + 2));
                    int digit2 = Integer.parseInt(value2.getOrgCode().substring(i, i + 2));

                    if (digit1 != digit2) {
                        return digit1 - digit2;
                    }
                }
            } else if (isValue1Numeric) {
                // value1是数字，而value2不是，将value2放在value1之前
                return -1;
            } else if (isValue2Numeric) {
                // value2是数字，而value1不是，将value1放在value2之前
                return 1;
            }
            // 两个值都包含字母，或者两个值都是纯数字且每两位都相等，则按照原始顺序比较
            return value1.getOrgCode().compareTo(value2.getOrgCode());
        };

        Collections.sort(list, orgComparator);
        return list;
    }


}
