package com.junmp.jyzb.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.junmpProcess.dto.StartProcessInstanceDTO;
import com.junmp.junmpProcess.exception.WorkFlowException;
import com.junmp.junmpProcess.service.IFlowInstanceService;
import com.junmp.jyzb.api.bean.dto.PoliceFingerDto;
import com.junmp.jyzb.api.bean.dto.PolicemanDto;
import com.junmp.jyzb.api.bean.dto.UserRoleDto;
import com.junmp.jyzb.api.bean.query.CabinetReq;
import com.junmp.jyzb.api.bean.query.PoliceReassignmentReq;
import com.junmp.jyzb.api.bean.query.PolicemanReq;
import com.junmp.jyzb.api.bean.req.FormEqsReq;
import com.junmp.jyzb.api.bean.req.UpdatePolicemanReq;
import com.junmp.jyzb.api.bean.req.UpdateReassignmentReq;
import com.junmp.jyzb.api.exception.enums.*;
import com.junmp.jyzb.entity.*;
import com.junmp.jyzb.mapper.*;
import com.junmp.jyzb.service.*;
import com.junmp.jyzb.utils.*;
import com.junmp.v2.auth.password.BcryptPasswordStoredEncrypt;
import com.junmp.v2.common.bean.dict.SimpleDict;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.common.enums.LogicDelEnum;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import com.junmp.v2.file.api.constant.FileConstant;
import com.junmp.v2.sys.api.bean.user.SysUserDto;
import com.junmp.v2.sys.api.bean.user.UserSelectTreeNode;
import com.junmp.v2.sys.api.bean.user.req.SysUserReq;
import com.junmp.v2.sys.api.bean.user.req.UserOrgReq;
import com.junmp.v2.sys.user.entity.SysUser;
import com.junmp.v2.sys.user.entity.SysUserOrg;
import com.junmp.v2.sys.user.entity.SysUserRole;
import com.junmp.v2.sys.user.factory.SysUserCreateFactory;
import com.junmp.v2.sys.user.mapper.SysUserMapper;
import com.junmp.v2.sys.user.service.SysUserOrgService;
import com.junmp.v2.sys.user.service.SysUserRoleService;
import com.junmp.v2.sys.user.service.SysUserService;
import liquibase.pro.packaged.L;
import liquibase.pro.packaged.O;
import lombok.extern.slf4j.Slf4j;
import org.apache.catalina.User;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;


@Service
@Slf4j
public class PolicemanServiceImpl extends ServiceImpl<PolicemanMapper, Policeman> implements PolicemanService {

    @Resource
    private RedisUtils redisUtils;

    @Resource
    private PolicemanMapper policemanMapper;


    @Resource
    private PubOrgService pubOrgService;

    @Resource
    private CabinetService cabinetService;

    @Resource
    private CabinetBoxService cabinetBoxService;

    @Resource
    private PoliceFingerService policeFingerService;

    @Resource
    private SysUserService sysUserService;

    @Resource
    private PoliceEquipmentService policeEquipmentService;

    @Resource
    private ReassignmentService reassignmentService;

    @Resource
    private IFlowInstanceService FlowInstanceService;

    @Resource
    private SysUserOrgService sysUserOrgService;

    @Resource
    private SysUserRoleService sysUserRoleService;

    private static final String REDIS_POLICE = "Policeman_";
    private static final String REDIS_ORG = "Organization_";


    /**
     * 添加警员信息
     *
     * @param req
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public String AddPoliceman(UpdatePolicemanReq req) {
        //查询传入的组织机构id是否存在
        pubOrgService.PubOrgExist(req.getOrgId());
        //绑定账号
        SysUser sysUser = add(req);
        //判断是否添加角色，进行绑定
        List<SysUserRole> sysUserRoleList=new ArrayList<>() ;
        if (req.getRolesList().size()>0 ){
            for (Long roleId: req.getRolesList()) {
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setRoleId(roleId);
                sysUserRole.setUserId(sysUser.getUserId());
                sysUserRole.setCreateTime(DateTimeUtil.getCurrentDateTime());
                sysUserRole.setCreateUser(req.getCreateUser());
                sysUserRoleList.add(sysUserRole);
            }
        }
        sysUserRoleService.saveBatch(sysUserRoleList);
        Policeman policeman = new Policeman();
        BeanPlusUtil.copyProperties(req, policeman);
        policeman.setPassword(sysUser.getPassword());
        policeman.setState(1);
        policeman.setUserId(sysUser.getUserId());
        save(policeman);

        return policeman.getId();
    }


    /**
     * 警员绑定账号
     *
     * @param
     * @return
     */
    public SysUser add(UpdatePolicemanReq req) {
        //判断是否有重复的账号
        SysUser one = sysUserService.getOne(new LambdaQueryWrapper<SysUser>()
                .eq(SysUser::getAccount, req.getAccount()));
        if (ObjectUtil.isNotNull(one)){
            throw new ServiceException(UserExceptionEnum.USER_IS_EXIST);
        }
        SysUser sysUser= new SysUser();
        BeanPlusUtil.copyProperties(req,sysUser);
        sysUser.setNickName(req.getName());
        sysUser.setRealName(req.getName());
        SysUserCreateFactory.fillAddSysUser(sysUser);
        sysUser.setAvatar(FileConstant.DEFAULT_AVATAR_FILE_ID);
        sysUser.setDelFlag(LogicDelEnum.N.getCode());
        sysUser.setCreateTime(DateTime.now());
        sysUser.setUpdateTime(DateTime.now());
        sysUserService.save(sysUser);
        sysUserOrgService.add(sysUser.getUserId(), req.getOrgId(), null);
        return sysUser;
    }



    // 更新缓存的方法，新增警员信息时调用
    private void updatePoliceIdCache(String orgId, String newPoliceId) {
        // 构建 Redis 缓存键
        String redisKeyFalse = "getAllPoliceId_false_" + orgId;
        String redisKeyTrue = "getAllPoliceId_true_" + orgId;

        // 从 Redis 中获取旧的缓存数据
        List<String> cachedDataFalse = redisUtils.findCachedData(redisKeyFalse);
        List<String> cachedDataTrue = redisUtils.findCachedData(redisKeyTrue);

        //如果缓存中没有数据，则直接查询数据库并更新Redis缓存
        //如果缓存中有数据，就更新数据
        if (cachedDataFalse == null && cachedDataTrue == null) {
            //getAllPoliceId(Map.of("IncludeLowerLevel", false, "orgId", orgId));
            return;
        } else if (cachedDataFalse != null) {
            cachedDataFalse.add(newPoliceId);
            redisUtils.set(redisKeyFalse, cachedDataFalse);
        } else if (cachedDataTrue != null) {
            cachedDataTrue.add(newPoliceId);
            redisUtils.set(redisKeyTrue, cachedDataTrue);
        }
    }

    //删除缓存的方法
    private void deletePoliceIdCache(String orgId) {
        //构建 Redis 缓存键
        String redisKey = "getAllPoliceId_false_" + orgId;
        redisUtils.delete(redisKey);

        //构建 Redis 缓存键
        redisKey = "getAllPoliceId_true_" + orgId;
        redisUtils.delete(redisKey);
    }


    /**
     * @param req
     * @return
     */
    @Override
    public PolicemanDto GetOnePolice(PolicemanReq req) {
        Policeman one = PoliceExist(req.getId());
        PolicemanDto policemanDto = new PolicemanDto();
        BeanPlusUtil.copyProperties(one, policemanDto);
        //将警员的指纹信息查询出来
        List<PoliceFinger> list1 = policeFingerService.list(new LambdaQueryWrapper<PoliceFinger>()
                .eq(ObjectUtil.isNotNull(req.getId()), PoliceFinger::getPoliceId, req.getId()));
        List<PoliceFingerDto> fingerDtoList = new ArrayList<>();
        for (PoliceFinger policeFinger : list1) {
            PoliceFingerDto policeFingerDto = new PoliceFingerDto();
            BeanPlusUtil.copyProperties(policeFinger, policeFingerDto);
            fingerDtoList.add(policeFingerDto);
        }
        policemanDto.setFingersList(fingerDtoList);
        //将账号名称返回
        policemanDto.setAccount(sysUserService.getById(policemanDto.getUserId()).getAccount());
        //通过警员信息将该警员的角色id返回
        List<SysUserRole> list = sysUserRoleService.list(new LambdaQueryWrapper<SysUserRole>()
                .eq(SysUserRole::getUserId, policemanDto.getUserId()));
        List<Long> collect = list.stream().map(sysUserRole -> {
            Long roleId = sysUserRole.getRoleId();
            return roleId;
        }).collect(Collectors.toList());
        policemanDto.setRolesList(collect);
        return policemanDto;
    }


    /**
     * 删除警员信息
     *
     * @param req
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean DeletePolice(UpdatePolicemanReq req) {
        //通过警员id查询警员信息
        Policeman policeman = PoliceExist(req.getId());
        //如果查询出来的警员信息中没有绑定箱门而参数传递了箱门id，则抛出异常警员绑定箱门错误
        //如果传递的箱门id参数与查询出来的箱门id不一致，则抛出异常警员绑定的箱门与实际绑定不符合
        if ((ObjectUtil.isNull(policeman.getCabinetBoxId()) && ObjectUtil.isNotNull(req.getCabinetBoxId()))) {
            throw new ServiceException(CabinetBoxExceptionEnum.CABINETBOX_ISNOT_EXISTS);
        }
        //通过警员信息中的userId对账号进行删除
        sysUserService.remove(new LambdaQueryWrapper<SysUser>()
                .eq(SysUser::getUserId, policeman.getUserId()));
        //还要对关系表进行删除
        sysUserOrgService.remove(new LambdaQueryWrapper<SysUserOrg>().eq(SysUserOrg::getUserId,policeman.getUserId()));
        return removeById(req.getId());

    }


    /**
     * 修改警员信息
     *
     * @param req
     * @return
     */
    @Override
    public boolean UpdatePolice(UpdatePolicemanReq req) {

        Policeman policeman = new Policeman();
        BeanPlusUtil.copyProperties(req, policeman);
        //查询传入的组织机构id是否存在
        pubOrgService.PubOrgExist(req.getOrgId());
        //判断传入的修改的警员编号与本身编号一致，如果一致则无所谓，如果不一致则需要判断修改的警员编号是否已经存在
        //判断警员是否存在
        Policeman one = PoliceExist(req.getId());
        if (!req.getPoliceCode().equals(one.getPoliceCode())) {
            Policeman one1 = getOne(new LambdaQueryWrapper<Policeman>()
                    .eq(ObjectUtil.isNotNull(req.getPoliceCode()), Policeman::getPoliceCode, req.getPoliceCode()));
            if (ObjectUtil.isNotNull(one1)) {
                throw new ServiceException(PolicemanExceptionEnum.POLICECODE_IS_EXISTS);
            }
        }
        //判断是否传递了箱子id，如果传了则判断箱子是否存在
        if (ObjectUtil.isNotNull(req.getCabinetBoxId()) && !req.getCabinetBoxId().equals("")){
            //查询单警柜箱号是否存在,箱门不存在抛异常
            cabinetBoxService.CabinetBoxExist(req.getCabinetBoxId());
        }
        policeman.setUpdateTime(DateTimeUtil.getCurrentDateTime());

        return updateById(policeman);
    }


    /**
     * 修改警员状态
     *
     * @param req
     * @return
     */
    @Override
    public boolean ChangePoliceState(UpdatePolicemanReq req) {
        //通过警员id查询出警员信息
        Policeman one = PoliceExist(req.getId());
        //判断状态码是否是0或1
        if (req.getState()!=1 && req.getState()!=0){
            throw new ServiceException(CabinetExceptionEnum.PARAMETER_ERROR);
        }
        one.setState(req.getState());
        return updateById(one);

    }

    public List<Map<String, Object>> getAllPolicemanMsg(Map<String, Object> msg, List<String> allPoliceId) {
        List<Map<String, Object>> allPoliceman = new ArrayList<>();
        // 构建 Redis 缓存键
        String redisKey = REDIS_ORG + msg.get("IncludeLowerLevel").toString() + '_' + msg.get("orgId").toString();
        // 从 Redis 中获取数据
        List<Map<String, Object>> cachedData = redisUtils.findCachedData(redisKey);
        if (cachedData != null) {
            //将Long类型的数据转化为Date
            for (Map<String, Object> one : cachedData) {
                Long dataMsg = (Long) one.get("updateTime");
                one.put("updateTime", redisUtils.getDate(dataMsg));
                allPoliceman.add(one);
            }
            return cachedData;
        }
        for (String policeId : allPoliceId) {
            Map<String, Object> policeMsg = policemanMapper.getOnePolice(policeId);
            allPoliceman.add(policeMsg);
        }

        //按照updateTime降序排序
        DateTimeUtil.timeSort(allPoliceman);

        //将查询结果存入 Redis 中
        redisUtils.set(redisKey, allPoliceman);
        return allPoliceman;
    }

    /**
     * 通过条件查询警员列表(list)
     *
     * @param
     */
    @Override
    public List<PolicemanDto> GetAllPolicemanList(PolicemanReq req) {
        //查询传入的组织机构id是否存在
        PubOrg pubOrg = pubOrgService.PubOrgExist(req.getOrgId());
        //查询出组织机构下的所有警员信息(如果是查看启用的那么state为1)
        List<Policeman> list = list(new LambdaQueryWrapper<Policeman>()
                .eq(ObjectUtil.isNotEmpty(req.getOrgId()), Policeman::getOrgId, req.getOrgId())
                .like(ObjectUtil.isNotEmpty(req.getName()),Policeman::getName,req.getName())
                .like(ObjectUtil.isNotEmpty(req.getPoliceCode()),Policeman::getPoliceCode,req.getPoliceCode())
                .eq(ObjectUtil.isNotEmpty( req.getState()),Policeman::getState, req.getState()));
        List<PolicemanDto> policeList = new ArrayList<>();
        //查询出警员信息下的指纹列表信息
        for (Policeman p : list) {
            PolicemanDto policemanDto = new PolicemanDto();
            BeanPlusUtil.copyProperties(p, policemanDto);
            List<PoliceFinger> list1 = policeFingerService.list(new LambdaQueryWrapper<PoliceFinger>()
                    .eq(ObjectUtil.isNotNull(p.getId()), PoliceFinger::getPoliceId, p.getId()));
            List<PoliceFingerDto> policeFingerDtoList = new ArrayList<>();
            for (PoliceFinger policeFinger : list1) {
                PoliceFingerDto policeFingerDto = new PoliceFingerDto();
                BeanPlusUtil.copyProperties(policeFinger, policeFingerDto);
                policeFingerDtoList.add(policeFingerDto);
            }
            policemanDto.setFingersList(policeFingerDtoList);
            policemanDto.setOrgName(pubOrg.getOrgName());
            policeList.add(policemanDto);

        }
        return policeList;
    }

    //通过组织机构id查询警员列表(page)
    @Override
    public PageResult<PolicemanDto> GetAllPolicemanPage(PolicemanReq req) {
        //查询传入的组织机构id是否存在
        PubOrg pubOrg = pubOrgService.PubOrgExist(req.getOrgId());
        //查询出组织机构下的所有警员信息
        LambdaQueryWrapper<Policeman> eq = new LambdaQueryWrapper<Policeman>()
                .eq(ObjectUtil.isNotEmpty(req.getOrgId()), Policeman::getOrgId, req.getOrgId())
                .like(ObjectUtil.isNotEmpty(req.getName()), Policeman::getName, req.getName())
                .like(ObjectUtil.isNotEmpty(req.getPoliceCode()), Policeman::getPoliceCode, req.getPoliceCode())
                .eq(ObjectUtil.isNotEmpty(req.getState()), Policeman::getState, req.getState());
        long size = list(eq).size();
        Page<Policeman> page = page(PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize()), eq);
        List<Policeman> records = page.getRecords();
        List<PolicemanDto> policeList = new ArrayList<>();
        //查询出警员信息下的指纹列表信息
        for (Policeman p : records) {
            PolicemanDto policemanDto = new PolicemanDto();
            BeanPlusUtil.copyProperties(p, policemanDto);
            List<PoliceFinger> list1 = policeFingerService.list(new LambdaQueryWrapper<PoliceFinger>()
                    .eq(ObjectUtil.isNotNull(p.getId()), PoliceFinger::getPoliceId, p.getId()));
            List<PoliceFingerDto> policeFingerDtoList = new ArrayList<>();
            for (PoliceFinger policeFinger : list1) {
                PoliceFingerDto policeFingerDto = new PoliceFingerDto();
                BeanPlusUtil.copyProperties(policeFinger, policeFingerDto);
                policeFingerDtoList.add(policeFingerDto);
            }
            policemanDto.setFingersList(policeFingerDtoList);
            policemanDto.setOrgName(pubOrg.getOrgName());
            policeList.add(policemanDto);

        }
        Page<PolicemanDto> page1 = PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize());
        page1.setRecords(policeList);
        page1.setTotal(size);
        return PageResultFactory.createPageResult(page1);
    }


    //根据单警柜id查询警员信息(list)
    @Override
    public List<PolicemanDto> GetPoliceData(CabinetReq req) {
        //判断单警柜id是否正确
        Cabinet cabinet = cabinetService.CabinetExist(req.getId());
        PubOrg pubOrg = pubOrgService.getOne(new LambdaQueryWrapper<PubOrg>()
                        .eq(PubOrg::getOrgId, cabinet.getOrgId()));
        //通过箱门id查询出警员
        List<Policeman> policemenList = policemanMapper.SearchPoliceList(req.getId());
        List<PolicemanDto> list = new ArrayList<>();
        for (Policeman policeman : policemenList) {
            PolicemanDto policemanDto = new PolicemanDto();
            BeanPlusUtil.copyProperties(policeman, policemanDto);
            //指纹信息查找
            List<PoliceFinger> fingerList = policeFingerService.list(new LambdaQueryWrapper<PoliceFinger>()
                    .eq(PoliceFinger::getPoliceId, policeman.getId()));
            List<PoliceFingerDto> fingerDtoList = new ArrayList<>();
            for (PoliceFinger policeFinger : fingerList) {
                PoliceFingerDto policeFingerDto = new PoliceFingerDto();
                BeanPlusUtil.copyProperties(policeFinger, policeFingerDto);
                fingerDtoList.add(policeFingerDto);
            }
            policemanDto.setFingersList(fingerDtoList);
            policemanDto.setCabinetNum(cabinet.getCabinetNum());
            policemanDto.setCabinetName(cabinet.getName());
            policemanDto.setOrgName(pubOrg.getOrgName());
            list.add(policemanDto);
        }
        return list;
    }


    //根据单警柜id查询警员信息(page)
    @Override
    public PageResult<PolicemanDto> GetPoliceDataPage(CabinetReq req) {
        //判断单警柜id是否正确
        Cabinet cabinet = cabinetService.CabinetExist(req.getId());
        PubOrg pubOrg = pubOrgService.getOne(new LambdaQueryWrapper<PubOrg>()
                .eq(PubOrg::getOrgId, cabinet.getOrgId()));
        //通过箱门id查询出警员
        Page<Policeman> page = PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize());
        long size = policemanMapper.SearchPoliceSize(req.getId());
        IPage<Policeman> policemenList = policemanMapper.SearchPolicePage(page,req.getId());
        List<PolicemanDto> list = new ArrayList<>();
        for (Policeman policeman : policemenList.getRecords()) {
            PolicemanDto policemanDto = new PolicemanDto();
            BeanPlusUtil.copyProperties(policeman, policemanDto);
            //指纹信息查找
            List<PoliceFinger> fingerList = policeFingerService.list(new LambdaQueryWrapper<PoliceFinger>()
                    .eq(PoliceFinger::getPoliceId, policeman.getId()));
            List<PoliceFingerDto> fingerDtoList = new ArrayList<>();
            for (PoliceFinger policeFinger : fingerList) {
                PoliceFingerDto policeFingerDto = new PoliceFingerDto();
                BeanPlusUtil.copyProperties(policeFinger, policeFingerDto);
                fingerDtoList.add(policeFingerDto);
            }
            policemanDto.setFingersList(fingerDtoList);
            policemanDto.setCabinetNum(cabinet.getCabinetNum());
            policemanDto.setCabinetName(cabinet.getName());
            policemanDto.setOrgName(pubOrg.getOrgName());
            list.add(policemanDto);
        }
        Page<PolicemanDto> page1 = PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize());
        page1.setRecords(list);
        page1.setTotal(size);
        return PageResultFactory.createPageResult(page1);
    }

    //添加人脸信息
    @Override
    public boolean AddFaceInfo(UpdatePolicemanReq req) {
        Policeman police = PoliceExist(req.getId());
        police.setFaceInfo(req.getFaceInfo());
        police.setUpdateTime(DateTimeUtil.getCurrentDateTime());
        return updateById(police);
    }

    /**
     * @param
     * @return
     * @author lxh
     * @description 更新人脸信息\删除人脸信息
     * 删除时：传一个null的人脸信息即可
     * @since 2023/7/18 15:02
     **/
    @Override
    public boolean UpdateFaceInfo(UpdatePolicemanReq req) {
        Policeman police = PoliceExist(req.getId());
        police.setFaceInfo(req.getFaceInfo());
        police.setUpdateTime(DateTimeUtil.getCurrentDateTime());
        return updateById(police);

    }

    /**
     * @param
     * @return
     * @author lxh
     * @description 查询人脸信息
     * @since 2023/7/18 15:02
     **/
    @Override
    public Policeman SearchFaceInfo(PolicemanReq req) {
        Policeman policeman = PoliceExist(req.getId());
        return policeman;
    }


    

    //人员绑定箱门
    @Override
    public boolean PoliceBindBox(PolicemanReq req) {
        Policeman policeman = PoliceExist(req.getId());
        BeanPlusUtil.copyProperties(req, policeman);
        //判断箱子是否存在
        cabinetBoxService.CabinetBoxExist(req.getCabinetBoxId());
        return updateById(policeman);
    }

    /**
     * 通过警员id判断警员是否存在，不存在则抛出异常
     */
    @Override
    public Policeman PoliceExist(String policeId) {
        Policeman policeman = getOne(new LambdaQueryWrapper<Policeman>()
                .eq(Policeman::getId,policeId));
        if (ObjectUtil.isNull(policeman)) {
            throw new ServiceException(PolicemanExceptionEnum.POLICEMAN_NOT_EXIST);
        }
        return policeman;
    }

    //删除账号时同时对警员的信息进行更改操作
    @Override
    public boolean UpdatePoliceInfo(UserOrgReq req) {
        Policeman police = getOne(new LambdaQueryWrapper<Policeman>().eq(Policeman::getUserId,req.getUserId()));
        if (ObjectUtil.isNull(police)) {
            //如果查询不到，表示该账号不是警员的，直接删除就行，不需要做任何操作
            return true;
        }
        police.setUserId(null);
        police.setPassword(null);
        return updateById(police);
    }

    //警员调岗
    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean changePoliceOrg(PoliceReassignmentReq req) {
        //通过警员id查询出该警员的基本信息
        Policeman policeman = getById(req.getId());
        //将其组织机构号设为空
        policeman.setOrgId(null);
        //如果警员绑定账号，将警员的账号进行删除
        if (ObjectUtil.isNotNull(policeman.getUserId())){
            policeman.setUserId(null);
            policeman.setPassword(null);
            sysUserService.removeById(policeman.getUserId());
        }

        //修改警员的个人信息(删除指纹信息)
        List<PoliceFinger> list = policeFingerService.list(new LambdaQueryWrapper<PoliceFinger>()
                .eq(PoliceFinger::getPoliceId, policeman.getId()));
        if (list.size()!=0){
            policeFingerService.removeBatchByIds(list);
        }
        //如果绑定箱门，进行解绑
        if (ObjectUtil.isNotNull(policeman.getCabinetBoxId())){
            policeman.setCabinetBoxId(null);
        }
        //对装备进行相关操作
        //判断前端传递的装备列表是否为空，如果为空则表示该警员不拿走任何装备信息
        if (req.getEqsReqList().size()==0){
            LambdaQueryWrapper<PoliceEquipment> eq = new LambdaQueryWrapper<PoliceEquipment>()
                    .eq(PoliceEquipment::getPoliceId, policeman.getId());
            //查询该警员是否存在装备信息，如果存在则进行删除
            List<PoliceEquipment> list1 = policeEquipmentService.list(eq);
            if (list1.size()!=0){
                policeEquipmentService.remove(eq);
            }
        }else{
            //警员带走的装备（如果没有全部拿走，那么剩下的装备信息删除）那么他带走的装备怎么处理呢，应该是inventory这张表中的数据进行操作，但是具体是哪几件装备修改信息呢？应该是具体到epc的吧
            for (FormEqsReq eqsReq:req.getEqsReqList()) {

            }
        }
        return updateById(policeman);
    }

    //获取警员下面的装备
    @Override
    public PageResult<PoliceEquipment> GetPoliceEqs(PolicemanReq req) {
        LambdaQueryWrapper<PoliceEquipment> eq = new LambdaQueryWrapper<PoliceEquipment>()
                .eq(PoliceEquipment::getPoliceId, req.getId());
        Page<PoliceEquipment> page = policeEquipmentService
                .page(PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize()), eq);
        return PageResultFactory.createPageResult(page);
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean UpdatePoliceUser() {
        List<Policeman> list = list();
        List<Policeman> policemanList=new ArrayList<>();
        list.forEach(policeman -> {
            //如果警员存在账号，则跳过循环，继续下一条警员的信息
            if (ObjectUtil.isNotNull(policeman.getUserId())){
                return;
            }
            SysUser sysUser= new SysUser();
            sysUser.setPhone(policeman.getPhone());
            sysUser.setTel(policeman.getTel());
            //没有账号，默认是警员的编号
            sysUser.setAccount(policeman.getPoliceCode());
            sysUser.setNickName(policeman.getName());
            sysUser.setRealName(policeman.getName());
            SysUserCreateFactory.fillAddSysUser(sysUser);
            sysUser.setAvatar(FileConstant.DEFAULT_AVATAR_FILE_ID);
            sysUser.setDelFlag(LogicDelEnum.N.getCode());
            sysUser.setCreateTime(DateTime.now());
            sysUser.setUpdateTime(DateTime.now());
            sysUserService.save(sysUser);
            sysUserOrgService.add(sysUser.getUserId(), policeman.getOrgId(), null);
            policeman.setUserId(sysUser.getUserId());
            policemanList.add(policeman);
        });
        return updateBatchById(policemanList);
    }

    //警员调岗申请
    @Override
    public String PoliceReassignment(UpdateReassignmentReq req) {
        Reassignment reassignment = new Reassignment();
        BeanPlusUtil.copyProperties(req,reassignment);
        reassignmentService.save(reassignment);
        //执行工作流
        if (req.getExamineState().equals("working"))
        {
            StartProcessInstanceDTO startProcessInstanceDTO=new StartProcessInstanceDTO();
            startProcessInstanceDTO.setProcessDefinitionId(req.getProcessDefinitionId());
            startProcessInstanceDTO.setOrderId(reassignment.getId());
            startProcessInstanceDTO.setOrderType("workOrder");
            startProcessInstanceDTO.setUserId(req.getUserId());
            String ProcessInstanceId= FlowInstanceService.startProcessInstanceById(startProcessInstanceDTO);
            reassignment.setProcessId(ProcessInstanceId);
        }
        return reassignment.getId();
    }

    //查看警员调岗申请单
    @Override
    public PageResult<Reassignment> ShowReassignmentPage(UpdateReassignmentReq req) {
        //(如果传其他不是数据库字段参数或者排序规则不是deac或者asc可能会出现错误)
        if (ObjectUtil.isNotNull(req.getColumn()) && !req.getColumn().trim().isEmpty() &&
                (req.getOrder().equalsIgnoreCase("asc")|| req.getOrder().equalsIgnoreCase("desc")) &&
                ObjectUtil.isNotNull(req.getOrder()) && !req.getOrder().trim().isEmpty()) {
            //修改字段，和数据库字段进行统一
            req.setColumn(req.getColumn().replaceAll("[A-Z]", "_$0").toLowerCase());
            req.setOrder(req.getOrder().toLowerCase());
        }
        LambdaQueryWrapper<Reassignment> eq = new LambdaQueryWrapper<Reassignment>()
                .eq(ObjectUtil.isNotNull(req.getOrgId()), Reassignment::getOrgId, req.getOrgId())
                .eq(ObjectUtil.isNotNull(req.getTargetOrgId()), Reassignment::getTargetOrgId, req.getTargetOrgId())
                .eq(ObjectUtil.isNotNull(req.getExamineState()), Reassignment::getExamineState, req.getExamineState())
                .like(ObjectUtil.isNotNull(req.getPoliceName()), Reassignment::getPoliceName, req.getPoliceName())
                .ge(ObjectUtil.isNotNull(req.getStartTime()), Reassignment::getApplyTime, req.getStartTime())
                .le(ObjectUtil.isNotNull(req.getEndTime()), Reassignment::getApplyTime, req.getEndTime())
                .last("order by " + req.getColumn() + " " + req.getOrder());
        Page<Reassignment> page = reassignmentService.page(PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize()), eq);
        return PageResultFactory.createPageResult(page);
    }

    //查询组织机构下的用户以及角色信息(也可以根据别的查询条件查询)
    @Override
    public PageResult<SysUserDto> ShowUserRole(SysUserReq req) {
        Integer numRoles=0;
        if (ObjectUtil.isNotNull(req.getGrantRoleIdList()) && req.getGrantRoleIdList().size() > 0){
            numRoles=req.getGrantRoleIdList().size();
        }
        //查询出所有用户以及用户角色
        List<UserRoleDto> list=policemanMapper.ShowUserRole(req,numRoles);
        //将查询的条件合并（如果一用户有多个角色，那么将该用户的角色id存入列表）
        List<Long> uniqueUsers = new ArrayList<>();
        List<SysUserDto> sysUserDtos=new ArrayList<>();

        for (UserRoleDto userRoleDto : list) {
            // 初始化 uniqueUsers 列表
            if (sysUserDtos.size()==0) {
                SysUserDto sysUserDto = new SysUserDto();
                BeanPlusUtil.copyProperties(userRoleDto,sysUserDto);
                uniqueUsers.add(userRoleDto.getRoleId());
                sysUserDto.setGrantRoleIdList(uniqueUsers);
                sysUserDtos.add(sysUserDto);
                continue;
            }

            boolean foundUser = false;
            for (SysUserDto list1:sysUserDtos) {
                //如果不存在则进行添加，如果已经存在则直接修改角色列表
                if (userRoleDto.getUserId().equals(list1.getUserId())) {
                    uniqueUsers.add(userRoleDto.getRoleId());
                    list1.setGrantRoleIdList(uniqueUsers);
                    foundUser = true;
                    break;
                }
            }
            if (!foundUser){
                SysUserDto sysUserDto = new SysUserDto();
                BeanPlusUtil.copyProperties(userRoleDto, sysUserDto);
                uniqueUsers = new ArrayList<>();
                uniqueUsers.add(userRoleDto.getRoleId());
                sysUserDto.setGrantRoleIdList(uniqueUsers);
                sysUserDtos.add(sysUserDto);
            }
        }
        Page<SysUserDto> page=PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize());
        page.setRecords(sysUserDtos);
        page.setTotal(sysUserDtos.size());
        return PageResultFactory.createPageResult(page);
    }

}
