package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.junmpProcess.dto.StartProcessInstanceDTO;
import com.junmp.junmpProcess.service.IFlowInstanceService;
import com.junmp.jyzb.api.bean.dto.OrderDetailDto;
import com.junmp.jyzb.api.bean.dto.OrderDto;
import com.junmp.jyzb.api.bean.dto.OrderMainDto;
import com.junmp.jyzb.api.bean.query.OrderDetailReq;
import com.junmp.jyzb.api.bean.query.OrderMainReq;
import com.junmp.jyzb.api.bean.query.OrderUploadReq;
import com.junmp.jyzb.api.bean.req.UpdateOrderDetailReq;
import com.junmp.jyzb.api.bean.query.QueryOrderLogReq;
import com.junmp.jyzb.api.bean.req.UpdateOrderReq;
import com.junmp.jyzb.api.bean.vo.InOrderInfo;
import com.junmp.jyzb.api.exception.enums.CabinetExceptionEnum;
import com.junmp.jyzb.api.exception.enums.OrderExceptionEnum;
import com.junmp.jyzb.entity.*;
import com.junmp.jyzb.mapper.OrderMainMapper;
import com.junmp.jyzb.service.*;
import com.junmp.jyzb.utils.DateTimeUtil;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.exception.enums.DefaultBizExceptionEnum;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.common.util.HttpServletUtil;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import com.junmp.v2.dict.entity.SysDictItem;
import com.junmp.v2.dict.service.SysDictItemService;
import com.junmp.v2.office.api.OfficeExcelApi;
import com.junmp.v2.office.api.bean.ExcelExportParam;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.core.*;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.management.remote.rmi._RMIConnection_Stub;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;


@Service
public class OrderMainServiceImpl extends ServiceImpl<OrderMainMapper, OrderMain> implements OrderMainService {

    @Resource
    private OrderDetailService orderDetailService;
    @Resource
    private RabbitTemplate rabbitTemplate;
    @Resource
    private RabbitAdmin rabbitAdmin;

    @Resource
    private OrderNumService orderNumService;

    @Resource
    private PubOrgService pubOrgService;

    @Resource
    private OrderMainMapper orderMainMapper;

    @Resource
    private SysDictItemService sysDictItemService;

    @Resource
    private OrderLogService orderLogService;
    @Resource
    private IFlowInstanceService FlowInstanceService;
    @Resource
    private OfficeExcelApi officeExcelApi;

    @Resource
    private InventorySummaryService inventorySummaryService;

    @Resource
    private WarehouseService warehouseService;


    @Transactional(rollbackFor = Exception.class)
    @Override
    public List<String> AddOrder(UpdateOrderReq req) {
        //判断是否有工作流id，如果有则将状态进行修改
        if (ObjectUtil.isEmpty(req.getProcessDefinitionId())) {
            req.setExamineState("none");
        } else {
            req.setExamineState("working");
        }
        OrderMain order = new OrderMain();
        BeanPlusUtil.copyProperties(req, order);
        //先判断该单据id是否存在，如果存在，进行更新操作即可
        if (ObjectUtil.isNotNull(req.getId()) && ! req.getId().trim().isEmpty()){
            //删除子单据
            orderDetailService.remove(new LambdaQueryWrapper<OrderDetail>()
                    .eq(ObjectUtil.isNotNull(req.getId()),OrderDetail::getOrderId,req.getId()));
        }else {
            //设置id
            String id=UUID.randomUUID().toString();
            order.setId(id);
            //设置单据单号
            OrderNum orderNum = setOrderCode(req);
            String codeValue=String.format("%04d",orderNum.getNum());
            order.setOrderCode(orderNum.getBussinessType()+orderNum.getYear()+
                    String.format("%02d",LocalDateTime.now().getMonth().getValue())+
                    String.format("%02d",LocalDateTime.now().getDayOfMonth())+codeValue);
        }
        //设置总价格和应出入库数量
        Integer sumNum=0;
        BigDecimal priceTotal=new BigDecimal(0);
        List<OrderDetail> detailList = new ArrayList<>();
        //通过遍历批量保存详细信息
        for (UpdateOrderDetailReq listReq:req.getDetailList()) {
            OrderDetail detail=new OrderDetail();
            BeanPlusUtil.copyProperties(listReq, detail);
            detail.setOrderId(order.getId());
            //设置单据类型
            detail.setType(order.getOrderType());
            //将数量和价格进行累加
            sumNum += detail.getPlanNum();
            priceTotal = priceTotal.add(BigDecimal.valueOf(detail.getPlanNum()).multiply(detail.getPrice())) ;
            detail.setCreateTime(DateTimeUtil.getCurrentDateTime());
            detailList.add(detail);
        }
        orderDetailService.saveBatch(detailList);
        //设置总价格和总数量
        order.setPrice(priceTotal);
        order.setInventoryQuantity(sumNum);
        order.setCreateTime(DateTimeUtil.getCurrentDateTime());
        //执行工作流
        if (req.getExamineState().equals("working"))
        {
//            UpdateOrderReq updateOrderReq = new UpdateOrderReq();
//            BeanPlusUtil.copyProperties(order,updateOrderReq);
//            List<UpdateOrderDetailReq> collect = detailList.stream().map(orderDetail -> {
//                UpdateOrderDetailReq updateOrderDetailReq = new UpdateOrderDetailReq();
//                BeanPlusUtil.copyProperties(orderDetail, updateOrderDetailReq);
//                return updateOrderDetailReq;
//            }).collect(Collectors.toList());
//            updateOrderReq.setDetailList(collect);
            StartProcessInstanceDTO startProcessInstanceDTO=new StartProcessInstanceDTO();
            startProcessInstanceDTO.setProcessDefinitionId(req.getProcessDefinitionId());
            startProcessInstanceDTO.setOrderId(order.getId());
            startProcessInstanceDTO.setOrderType("workOrder");
            startProcessInstanceDTO.setUserId(req.getUserId());
//            startProcessInstanceDTO.setFormData( (JSONObject) JSONObject.toJSON(updateOrderReq));
            String ProcessInstanceId= FlowInstanceService.startProcessInstanceById(startProcessInstanceDTO);
            order.setProcessId(ProcessInstanceId);

        }
        if (ObjectUtil.isNotNull(req.getId()) && ! req.getId().trim().isEmpty()){
            boolean b = updateById(order);
            System.out.println("b = " + b);
        }else {
            //保存
            boolean save = this.save(order);
            System.out.println(save);
        }
        //list返回数据
        List<String> list=new ArrayList<>();
        list.add(order.getId());
        for (OrderDetail orderDetail:detailList) {
            list.add(Long.toString(orderDetail.getId()));
        }
        return list;
    }


    //设置单据单号（并且对order_num表进行新增或者更新）
    public OrderNum setOrderCode(UpdateOrderReq req){
        //设置采购单号，需要先判断该组织机构的采购单号是否存在，如果存在则将数量进行增加，如果不存在则新增一条对应的数据
        OrderNum orderNum = new OrderNum();
        //获取年,月，日，获取业务出入状态，获取组织机构id，获取业务类型
        orderNum.setYear(LocalDateTime.now().getYear());
        //将业务类型转为中文简写(CK出库，RK入库)
        String itemValue = sysDictItemService.list(new LambdaQueryWrapper<SysDictItem>()
                .eq(SysDictItem::getItemText, req.getOrderType())).get(0).getItemValue();
        orderNum.setBussinessType(itemValue);
        //出入业务状态
        orderNum.setOutInType(req.getOrderType());
        //判断是出库还是入库，出库为发物单位，入库为收物单位
        OrderNum one = new OrderNum();
        if (req.getOrderType().equals("in")){
            orderNum.setEndOrgId(req.getEndOrgId());
            one = orderNumService.getOne(new LambdaQueryWrapper<OrderNum>()
                    .eq(OrderNum::getEndOrgId, orderNum.getEndOrgId())
                    .eq(OrderNum::getBussinessType, orderNum.getBussinessType())
                    .eq(OrderNum::getYear, orderNum.getYear())
                    .eq(OrderNum::getOutInType, orderNum.getOutInType()));
        }else {
            orderNum.setStartOrgId(Long.valueOf(req.getStartOrgId()));
            one = orderNumService.getOne(new LambdaQueryWrapper<OrderNum>()
                    .eq(OrderNum::getStartOrgId, orderNum.getStartOrgId())
                    .eq(OrderNum::getBussinessType,orderNum.getBussinessType())
                    .eq(OrderNum::getYear, orderNum.getYear())
                    .eq(OrderNum::getOutInType, orderNum.getOutInType()));
        }
        
        //设置num的数量
        if (ObjectUtil.isNull(one)){
            orderNum.setNum(1);
            orderNumService.save(orderNum);
            return orderNum;
        }else {
            one.setNum(one.getNum()+1);
            orderNumService.updateById(one);
            return one;
        }

    }


    //新增默认审核通过的任务单（可以没有工作流）
    @Transactional(rollbackFor = Exception.class)
    @Override
    public String AddFinishOrder(UpdateOrderReq req) {

        //添加到数据库中(如果该单据没有审批流，那么就直接存入数据库)
        if (ObjectUtil.isNull(req.getProcessDefinitionId())){
            List<String> strings = AddOrder(req);
            OrderMain orderMain = getById(strings.get(0));
            List<OrderDetail> list = orderDetailService.list(new LambdaQueryWrapper<OrderDetail>()
                    .eq(OrderDetail::getOrderId, strings.get(0)));
            BeanPlusUtil.copyProperties(orderMain,req);
            req.setExamineState("finished");
            List<UpdateOrderDetailReq> collect = list.stream().map(orderDetail -> {
                UpdateOrderDetailReq orderDetailReq = new UpdateOrderDetailReq();
                BeanPlusUtil.copyProperties(orderDetail, orderDetailReq);
                return orderDetailReq;
            }).collect(Collectors.toList());
            req.setDetailList(collect);

        }
        //将完成的任务单直接推送到消息队列rabbitmq中（需要判断是入库单还是出库单，入库单传发物单位id，出库单传收物单位id）
        //方法1：一个交换机，一个队列。通过中间对象，object存储对象，type表标识
//        if(req.getOrderType().equals("in")){
//            rabbitTemplate.convertAndSend("OrderExchange","OrderRouting",new MessageWrapper(req,req.getStartOrgId()));
//        }else {
//            rabbitTemplate.convertAndSend("OrderExchange","OrderRouting",new MessageWrapper(req,req.getEndOrgId()));
//        }
        //方法2：一个交换机，多个队列。动态创建队列
        String exchangeName="orderExchange";
        //需要判断是入库单还是出库单，入库单传收物单位id，出库单传发物单位id
        if(req.getOrderType().equals("in")){
            Queue queue=new Queue( req.getEndOrgId().toString(),true,false,false);
            Exchange exchange = new DirectExchange(exchangeName, true, false);
            rabbitAdmin.declareQueue(queue);
            rabbitAdmin.declareExchange(exchange);
            rabbitAdmin.declareBinding(BindingBuilder.bind(queue).to(exchange).with(req.getEndOrgId().toString()).noargs());
            rabbitTemplate.convertAndSend(exchangeName, req.getEndOrgId().toString(), req);
        }else {
            Queue queue = new Queue(req.getStartOrgId().toString(), true, false, false);
            Exchange exchange = new DirectExchange(exchangeName, true, false);
            rabbitAdmin.declareQueue(queue);
            rabbitAdmin.declareExchange(exchange);
            rabbitAdmin.declareBinding(BindingBuilder.bind(queue).to(exchange).with(req.getStartOrgId().toString()).noargs());
            rabbitTemplate.convertAndSend(exchangeName, req.getStartOrgId().toString(), req);
        }
        return req.getId();
    }


    //更新任务单（进入工作流中之后不能进行更改）
    @Transactional(rollbackFor = Exception.class)
    @Override
    public Boolean  updateOrder(UpdateOrderReq req) {
        OrderMain order = orderMainExist(req.getId());
        if (!order.getExamineState().equals("none"))
        {
            throw new ServiceException(OrderExceptionEnum.ORDER_CAN_NOT_UPDATE);
        }
        //（直接删除并重新插入数据）----------------------------------------------
        orderDetailService.remove(new LambdaQueryWrapper<OrderDetail>().eq(OrderDetail::getOrderId, req.getId()));
        Integer sumNum=0;
        BigDecimal priceTotal=new BigDecimal(0);
        List<OrderDetail> detailList = new ArrayList<>();
        for (UpdateOrderDetailReq listReq:req.getDetailList()) {
            OrderDetail detail=new OrderDetail();
            BeanPlusUtil.copyProperties(listReq, detail);
            detail.setOrderId(order.getId());
            //设置单据类型
            detail.setType(order.getOrderType());
            //将数量和价格进行累加
            sumNum += detail.getPlanNum();
            priceTotal = priceTotal.add(BigDecimal.valueOf(detail.getPlanNum()).multiply(detail.getPrice())) ;
            detail.setCreateTime(DateTimeUtil.getCurrentDateTime());
            detailList.add(detail);
        }
        orderDetailService.saveBatch(detailList);
        //设置总价格和总数量
        order.setPrice(priceTotal);
        order.setInventoryQuantity(sumNum);
        order.setCreateTime(DateTimeUtil.getCurrentDateTime());
        return this.updateById(order);
    }
    //更新任务单（进入工作流中之后不能进行更改）
    @Transactional(rollbackFor = Exception.class)
    @Override
    public Boolean  ChangeOrderState(UpdateOrderReq req) {
        OrderMain order = orderMainExist(req.getId());

        order.setExamineState(req.getExamineState());
        order.setOrderState(req.getOrderState());
        return this.updateById(order);
    }
    public boolean hasCommonElements(List<?> list1, List<?> list2) {
        for (Object item1 : list1) {
            if (list2.contains(item1)) {
                return true; // 找到相同值
            }
        }
        return false; // 没有相同值
    }

    //查询任务列表(根据组织机构id)
    @Override
    public PageResult<OrderMainDto> getOrderPage(OrderMainReq req) {
        Page<OrderMain> page = new Page<>();
        //排序字段处理，将驼峰改成和数据库同步的字段名(如果传其他不是数据库字段参数或者排序规则不是deac或者asc可能会出现错误)
        if (ObjectUtil.isNotNull(req.getColumn()) && !req.getColumn().trim().isEmpty() &&
                (req.getOrder().equalsIgnoreCase("asc")|| req.getOrder().equalsIgnoreCase("desc")) &&
                ObjectUtil.isNotNull(req.getOrder()) &&!req.getOrder().trim().isEmpty()) {
            //修改字段，和数据库字段进行统一
            req.setColumn(req.getColumn().replaceAll("[A-Z]", "_$0").toLowerCase());
            req.setOrder(req.getOrder().toLowerCase());
        }
        //根据查询条件得到单据
        IPage<OrderMain> outOrderPage = orderMainMapper.getOrderPage(PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize()),req);
        page.setRecords(outOrderPage.getRecords());
        page.setTotal(outOrderPage.getTotal());

        List<OrderMainDto> orderMainDtoList = page.getRecords().stream().map(orderMain -> {
            OrderMainDto orderMainDto = new OrderMainDto();
            BeanPlusUtil.copyProperties(orderMain,orderMainDto);
            return orderMainDto;
        }).collect(Collectors.toList());
        Page<OrderMainDto> page1 = PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize());
        page1.setTotal(page.getTotal());
        page1.setRecords(orderMainDtoList);
        return PageResultFactory.createPageResult(page1);
    }



    //根据任务单id查看业务明细
    @Override
    public OrderDto GetDetailById(OrderMainReq req) {
        //判断任务单是否存在
        OrderMain orderMain = orderMainExist(req.getId());
        OrderDto orderDto = new OrderDto();
        BeanPlusUtil.copyProperties(orderMain,orderDto);
        List<OrderDetail> list=new ArrayList<>();
        //排序字段处理，将驼峰改成和数据库同步的字段名
        //将详细信息存入列表属性中
        //通过任务单id查询对应的详细信息
        if (ObjectUtil.isNotNull(req.getColumn()) && !req.getColumn().trim().isEmpty() &&
                (req.getOrder().equalsIgnoreCase("asc")|| req.getOrder().equalsIgnoreCase("desc")) && !req.getOrder().trim().isEmpty()) {
            //修改字段，和数据库字段进行统一
            req.setColumn(req.getColumn().replaceAll("[A-Z]", "_$0").toLowerCase());
            list=orderDetailService.list(new LambdaQueryWrapper<OrderDetail>()
                    .eq(OrderDetail::getOrderId, req.getId())
                    .last("order by "+req.getColumn() +" "+req.getOrder()));

        } else {
            list = orderDetailService.list(new LambdaQueryWrapper<OrderDetail>()
                    .eq(OrderDetail::getOrderId, req.getId())
                    .orderByDesc(OrderDetail::getCreateTime));
        }
        List<OrderDetailDto> orderDetailDtoList=new ArrayList<>();
        for (OrderDetail orderDetail:list) {
            OrderDetailDto orderDetailDto = new OrderDetailDto();
            BeanPlusUtil.copyProperties(orderDetail,orderDetailDto);
            if (orderMain.getOrderType().equals("out")){
                InventorySummary one = inventorySummaryService.getOne(new LambdaQueryWrapper<InventorySummary>()
                        .eq(InventorySummary::getLocationId, orderDetail.getWarehouseId())
                        .eq(InventorySummary::getSizeId, orderDetail.getSizeId())
                        .eq(InventorySummary::getTypeId, orderDetail.getTypeId())
                        .eq(InventorySummary::getUnitPrice, orderDetail.getPrice()));
                orderDetailDto.setStockNumber(one.getStockNumber());
            }
            orderDetailDtoList.add(orderDetailDto);
        }
        orderDto.setDetailList(orderDetailDtoList);
        return orderDto;
    }

    //单据状态上报
    @Override
    public boolean PushState(OrderUploadReq req) {
        OrderMain orderMain = orderMainExist(req.getId());
        //获取单据的出入库，获取发物单位id或者收物单位id
        String orderType = orderMain.getOrderType();
        String exchangeName="OrderStateExchange";
        //推送到rabbitmq中去
        if (orderType.equals("in")){
            Long endOrgId = orderMain.getEndOrgId();
            Queue queue=new Queue(Long.toString(endOrgId),true,false,false);
            Exchange exchange = new DirectExchange(exchangeName, true, false);
            rabbitAdmin.declareQueue(queue);
            rabbitAdmin.declareExchange(exchange);
            rabbitAdmin.declareBinding(BindingBuilder.bind(queue).to(exchange).with(Long.toString(endOrgId)).noargs());
            rabbitTemplate.convertAndSend(exchangeName, Long.toString(endOrgId), req);

        }else {
            Long startOrgId = orderMain.getStartOrgId();
            Queue queue = new Queue(Long.toString(startOrgId), true, false, false);
            Exchange exchange = new DirectExchange(exchangeName, true, false);
            rabbitAdmin.declareQueue(queue);
            rabbitAdmin.declareExchange(exchange);
            rabbitAdmin.declareBinding(BindingBuilder.bind(queue).to(exchange).with(Long.toString(startOrgId)).noargs());
            rabbitTemplate.convertAndSend(exchangeName, Long.toString(startOrgId), req);
        }
        return true;
    }

    //记账
    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean Accounting(UpdateOrderReq req) {
        //判断传递的订单主id是否存在
        OrderMain orderMain = orderMainExist(req.getId());
        //记账子单据不能传空
        if (req.getDetailList().size()==0){
            throw new ServiceException(OrderExceptionEnum.ORDERDETAIL_ISNOT_NULL);
        }
        //前端传递的子单数据
        List<UpdateOrderDetailReq> reqList = req.getDetailList();
        //将记账数量进行相加
        Integer updateQuantity=0;
        //将价格进行添加修改
        BigDecimal priceTotal=new BigDecimal(0);
        //获取子单据
        List<OrderDetail> list = orderDetailService.list(new LambdaQueryWrapper<OrderDetail>()
                .eq(OrderDetail::getOrderId,req.getId()));
        //获取所有传递的子单据id
        Set<Long> collect = req.getDetailList().stream().map(UpdateOrderDetailReq::getId).collect(Collectors.toSet());
        //获取所有数据库的子单据id
        Set<Long> existingIds = list.stream().map(OrderDetail::getId).collect(Collectors.toSet());
        //创建一个操作记录
        StringBuilder stringBuilder = new StringBuilder();
        List<OrderDetail> orderDetailList=new ArrayList<>();
        //创建一个列表用于修改summary数据库表中数据。
        List<UpdateOrderDetailReq> orderDetailReqList=new ArrayList<>();
        //比较两个子单id完全一致,判断传递的子单据id在数据库中是否存在，如果不存在则抛出子单据不存在异常
        if (collect.size() == existingIds.size() && collect.containsAll(existingIds) && existingIds.containsAll(collect)){
            for (UpdateOrderDetailReq uploadDetailReq : reqList) {
                OrderDetail orderDetail = new OrderDetail();
                BeanPlusUtil.copyProperties(uploadDetailReq,orderDetail);
                //获取修改后的数量并且记录(如果modifyQuantity不为空并且于实际入库数量不一致则表示该子单据进行了修改)
                if (ObjectUtil.isNotNull(uploadDetailReq.getModifyQuantity()) && uploadDetailReq.getModifyQuantity() != uploadDetailReq.getActualNum()){
                    String log = "将"+uploadDetailReq.getTypeName()+"："+
                            uploadDetailReq.getSizeName()+"的物资数量从"+uploadDetailReq.getActualNum()+"修改为"+uploadDetailReq.getModifyQuantity()+";";
                    stringBuilder.append(log);
                    //修改单子数量数据,价格
                    orderDetail.setActualNum(uploadDetailReq.getModifyQuantity());
                    orderDetail.setUpdateTime(DateTimeUtil.getCurrentDateTime());
                    orderDetailList.add(orderDetail);
                    orderDetailReqList.add(uploadDetailReq);
                    //修改后数量
                    updateQuantity+=uploadDetailReq.getModifyQuantity();
                    priceTotal=priceTotal.add(BigDecimal.valueOf(uploadDetailReq.getModifyQuantity()).multiply(uploadDetailReq.getPrice()));
                }else {
                    //修改后数量
                    updateQuantity+=uploadDetailReq.getActualNum();
                    priceTotal=priceTotal.add(BigDecimal.valueOf(uploadDetailReq.getActualNum()).multiply(uploadDetailReq.getPrice()));
                }

            }
        }else {
            throw new ServiceException(OrderExceptionEnum.ORDERDETAIL_ERROR);
        }
        //批量更新子单据数量
        if (orderDetailList.size()!=0){
            orderDetailService.updateBatchById(orderDetailList);
        }

        //将修改内容存储记录（历史操作，数量，单据，价格，组织机构）
        //创建记账操作记录并且记录到数据表order_log中
        saveAccountingLog(req,stringBuilder,updateQuantity);

        //修改装备汇总表中的数据 inventory_summary
        Long orgId;
        if (orderMain.getOrderType().equals("in")){
            orgId=orderMain.getEndOrgId();
        }
        else {
            orgId=orderMain.getStartOrgId();
        }
        updateSummaryInfo(req,orderDetailReqList,orgId);

        //修改仓库表中的数量汇总信息(warehouse)
//        updateWarehouseInfo(req,orderDetailReqList,orgId);

        //更新主单据的数量和价格
        orderMain.setActualQuantity(updateQuantity);
        orderMain.setPrice(priceTotal);
        orderMain.setOrderState("finished");
        //修改记账状态，0未记账，1已记账
//        orderMain.setManualState(1);
        orderMain.setUpdateTime(DateTimeUtil.getCurrentDateTime());

        //如果是领用出库，那记账结束以后将装备挂到警员名下（存储到policemanEquipment表中）

        //更新主单据
        return updateById(orderMain);
    }

    //将修改内容存储记录（历史操作，数量，单据，价格，组织机构）
    //创建记账操作记录并且记录到数据表order_log中
    public void saveAccountingLog (UpdateOrderReq req,StringBuilder stringBuilder,Integer updateQuantity){
        OrderLog orderLog = new OrderLog();
        BeanPlusUtil.copyProperties(req,orderLog);
        orderLog.setId(UUID.randomUUID().toString());
        orderLog.setHistoryMsg(stringBuilder.toString());
        orderLog.setUpdateQuantity(updateQuantity);
        if (req.getOrderType().equals("in")){
            orderLog.setOrgId(req.getEndOrgId());
            orderLog.setOrgName(req.getEndOrgName());
        }else {
            orderLog.setOrgId(req.getStartOrgId());
            orderLog.setOrgName(req.getStartOrgName());
        }
        orderLog.setOrderId(req.getId());
        orderLog.setCreateTime(DateTimeUtil.getCurrentDateTime());
        //将记账记录保存
        orderLogService.save(orderLog);
    }

    //修改装备汇总表中的数据inventory_summary
    public void updateSummaryInfo(UpdateOrderReq req,List<UpdateOrderDetailReq> orderDetailReqList,Long orgId){
        //根据遍历该子单据，将summary中的对应数据进行修改
        List<InventorySummary> collect = orderDetailReqList.stream()
                .map(orderDetailReq -> {
                    InventorySummary one = inventorySummaryService.getOne(new LambdaQueryWrapper<InventorySummary>()
                            .eq(InventorySummary::getOrgId, orgId)
                            .eq(InventorySummary::getSizeId, orderDetailReq.getSizeId())
                            .eq(InventorySummary::getTypeId, orderDetailReq.getTypeId())
                            .eq(InventorySummary::getLocationId, orderDetailReq.getWarehouseId())
                            .eq(InventorySummary::getPrice, orderDetailReq.getPrice()));
                    //如果one为空，则添加一条数据？？？？？存疑

                    //更新数量和总价格，在库数和出库数也需要对应进行修改
                    //修改的数量和价格
                    BigDecimal totalPrice = one.getPrice().subtract(BigDecimal.valueOf(orderDetailReq.getActualNum()).multiply(orderDetailReq.getPrice()))
                            .add(BigDecimal.valueOf(orderDetailReq.getModifyQuantity()).multiply(orderDetailReq.getPrice()));
                    Integer totalNUmber = one.getNumber()-orderDetailReq.getActualNum()+orderDetailReq.getModifyQuantity();
                    one.setPrice(totalPrice);
                    one.setNumber(totalNUmber);
                    //判断单据是in还是out，对出库数量和在库数量进行修改
                    if (req.getOrderType().equals("in")){
                        one.setStockNumber(one.getStockNumber()-orderDetailReq.getActualNum()+orderDetailReq.getModifyQuantity());
                    }else {
                        one.setOutboundNumber(one.getOutboundNumber()-orderDetailReq.getActualNum()+orderDetailReq.getModifyQuantity());
                    }
                    return one;
                })
                .collect(Collectors.toList());
        inventorySummaryService.updateBatchById(collect);
    }

    //修改仓库表中的数量汇总信息
    public void updateWarehouseInfo(UpdateOrderReq req,List<UpdateOrderDetailReq> orderDetailReqList,Long orgId){
        for (UpdateOrderDetailReq orderDetailReq:orderDetailReqList) {
            Warehouse one = warehouseService.getOne(new LambdaQueryWrapper<Warehouse>()
                    .eq(Warehouse::getOrgId, orgId)
                    .eq(Warehouse::getId, orderDetailReq.getWarehouseId()));
            //修改总数量和总价格，并且判断单据类型来修改出库数量或者在库数量
            Integer totalNUmber = one.getSum()-orderDetailReq.getActualNum()+orderDetailReq.getModifyQuantity();
            BigDecimal totalPrice = one.getPriceTotal().subtract(BigDecimal.valueOf(orderDetailReq.getActualNum()).multiply(orderDetailReq.getPrice()))
                    .add(BigDecimal.valueOf(orderDetailReq.getModifyQuantity()).multiply(orderDetailReq.getPrice()));
            one.setPriceTotal(totalPrice);
            one.setSum(totalNUmber);
            //判断单据是in还是out，对出库数量和在库数量进行修改
            if (req.getOrderType().equals("in")){
                one.setInSum(one.getInSum()-orderDetailReq.getActualNum()+orderDetailReq.getModifyQuantity());
            }else {
                one.setOutSum(one.getOutSum()-orderDetailReq.getActualNum()+orderDetailReq.getModifyQuantity());
            }
            warehouseService.updateById(one);
        }
    }
    /**
     * 查看记账列表
     * @param req
     * @return
     */
    @Override
    public PageResult<OrderLog> ShowAccountingPage(QueryOrderLogReq req) {
        LambdaQueryWrapper<OrderLog> eq = new LambdaQueryWrapper<OrderLog>()
                .eq(ObjectUtil.isNotNull(req.getBussinessType()), OrderLog::getBussinessType, req.getBussinessType())
                .eq(ObjectUtil.isNotNull(req.getOrderType()), OrderLog::getOrderType, req.getOrderType())
//                .eq(ObjectUtil.isNotNull(req.getOrderId()), OrderLog::getOrgId, req.getOrgId())
                .ge(ObjectUtil.isNotNull(req.getStartTime()), OrderLog::getCreateTime, req.getStartTime())
                .le(ObjectUtil.isNotNull(req.getEndTime()), OrderLog::getCreateTime, req.getEndTime());
        Page<OrderLog> page = orderLogService.page(PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize()), eq);
        return PageResultFactory.createPageResult(page);
    }


    /**
     * 入库单导出功能
     * @param req
     */
    @Override
    public void InOrderExport(OrderMainReq req) {
        LambdaQueryWrapper<OrderMain> wrapper = createWrapper(req);
        List<InOrderInfo> collect = list(wrapper).stream().map(orderMain -> {
            InOrderInfo inOrderInfo = new InOrderInfo();
            BeanPlusUtil.copyProperties(orderMain, inOrderInfo);
            //装备名称
            String inventoryName = "";
            List<OrderDetail> orderDetailList = orderDetailService.QueryList(orderMain.getId());
            for (OrderDetail orderDetail : orderDetailList) {
                inventoryName = inventoryName + orderDetail.getTypeName() + "/";
            }
            String substring = inventoryName.substring(0, inventoryName.length() - 1);
            inOrderInfo.setInventoryName(substring);
            //查询字典表设置入库类型
//            List<SysDictItem> list = sysDictItemService.list(new LambdaQueryWrapper<SysDictItem>()
//                    .eq(SysDictItem::getItemValue, orderMain.getBussinessType()));
////            inOrderInfo.setOrderType(itemText);
//            System.out.println("list = " + list);
            return inOrderInfo;

        }).collect(Collectors.toList());
        //设置导出的单据序号
        for (int i = 1; i <= collect.size() ; i++) {
            collect.get(i-1).setNumId(i);
        }
        HttpServletResponse response = HttpServletUtil.getResponse();
        ExcelExportParam param = new ExcelExportParam();
        param.setDataList(collect);
        param.setClazz(InOrderInfo.class);
        param.setResponse(response);
        param.setFileName("入库单据列表.xls");
        //对数据进行导出
        officeExcelApi.easyExportDownload(param);

    }

    @Override
    public void OutOrderExport(OrderMainReq req) {
        LambdaQueryWrapper<OrderMain> wrapper = createWrapper(req);
        List<InOrderInfo> collect = list(wrapper).stream().map(orderMain -> {
            InOrderInfo inOrderInfo = new InOrderInfo();
            BeanPlusUtil.copyProperties(orderMain, inOrderInfo);
            //装备名称
            String inventoryName = "";
            List<OrderDetail> orderDetailList = orderDetailService.QueryList(orderMain.getId());
            for (OrderDetail orderDetail : orderDetailList) {
                inventoryName = inventoryName + orderDetail.getTypeName() + "/";
            }
            String substring = inventoryName.substring(0, inventoryName.length() - 1);
            inOrderInfo.setInventoryName(substring);
            //查询字典表设置出库类型
//            List<SysDictItem> list = sysDictItemService.list(new LambdaQueryWrapper<SysDictItem>()
//                    .eq(SysDictItem::getItemValue, orderMain.getBussinessType()));
////            inOrderInfo.setOrderType(itemText);
//            System.out.println("list = " + list);
            return inOrderInfo;

        }).collect(Collectors.toList());
        //设置导出的单据序号
        for (int i = 1; i <= collect.size() ; i++) {
            collect.get(i-1).setNumId(i);
        }
        HttpServletResponse response = HttpServletUtil.getResponse();
        ExcelExportParam param = new ExcelExportParam();
        param.setDataList(collect);
        param.setClazz(InOrderInfo.class);
        param.setResponse(response);
        param.setFileName("出库单据列表.xls");
        //对数据进行导出
        officeExcelApi.easyExportDownload(param);
    }


    //判断任务单是否存在
    @Override
    public OrderMain orderMainExist(String id) {
        OrderMain order = this.getById(id);
        if (ObjectUtil.isNull(order)) {
            throw new ServiceException(OrderExceptionEnum.ORDER_NOT_EXIST);
        }
        return order;
    }


    private LambdaQueryWrapper<OrderMain> createWrapper(OrderMainReq req) {
        LambdaQueryWrapper<OrderMain> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
        //单据类型（in入库，out出库）
        wrapper.eq(ObjectUtil.isNotEmpty(req.getOrderType()),OrderMain::getOrderType,req.getOrderType());
        //单据状态 ready待入/出库，finished已入/出库，working入/出库中
        wrapper.eq(ObjectUtil.isNotEmpty(req.getOrderState()), OrderMain::getOrderState, req.getOrderState());
//        //审核状态:none,未接入审核流，working审批中，finished已完成
        wrapper.eq(ObjectUtil.isNotEmpty(req.getExamineState()), OrderMain::getExamineState, req.getExamineState());
        //业务类型
        wrapper.eq(ObjectUtil.isNotEmpty(req.getBussinessType()), OrderMain::getBussinessType, req.getBussinessType());
        //组织机构id(入库单)
        wrapper.eq(ObjectUtil.isNotEmpty(req.getEndOrgId()),OrderMain::getEndOrgId,req.getEndOrgId());
        //组织机构id（出库单）
        wrapper.ge(ObjectUtil.isNotNull(req.getStartTime()),OrderMain::getCreateTime,req.getStartTime());
        wrapper.le(ObjectUtil.isNotNull(req.getEndTime()),OrderMain::getCreateTime,req.getEndTime());
        wrapper.orderByDesc(OrderMain::getCreateTime);

        return wrapper;

    }



}
