package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.dto.InventorySumDto;
import com.junmp.jyzb.api.bean.dto.WarehouseDto;
import com.junmp.jyzb.api.bean.query.InventoryReq;
import com.junmp.jyzb.api.bean.query.InventorySumReq;
import com.junmp.jyzb.api.bean.req.CabinetInOutRecordsReq;
import com.junmp.jyzb.api.bean.req.RabbitMqOrderReq;
import com.junmp.jyzb.entity.*;
import com.junmp.jyzb.service.*;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import com.junmp.v2.dict.entity.SysDictItem;
import com.junmp.v2.dict.service.SysDictItemService;
import liquibase.pro.packaged.L;
import org.springframework.stereotype.Service;
import com.junmp.jyzb.mapper.InventorySummaryMapper;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class InventorySummaryServiceImpl  extends ServiceImpl<InventorySummaryMapper, InventorySummary> implements InventorySummaryService {

    @Resource
    private PubOrgService pubOrgService;

    @Resource
    private OrderMainService orderMainService;

    @Resource
    private InventoryService inventoryService;

    @Resource
    private InventorySummaryMapper inventorySummaryMapper;

    @Resource
    private EquipmentSizeService equipmentSizeService;

    @Resource
    private OrderDetailService orderDetailService;

    @Resource
    private WarehouseService warehouseService;

    @Resource
    private LogSummaryService logSummaryService;

    @Resource
    private LogDetailService logDetailService;

    @Resource
    private CabinetBoxService cabinetBoxService;

    @Resource
    private SysDictItemService sysDictItemService;


    //根据条件查询库存汇总信息
    @Override
    public PageResult<InventorySummary> getEquipmentInfo(InventorySumReq req) {
        //当没有参数传递的时候默认查询全部，但是如果传递了条件，根据条件查询并且如果是根据id进行查询，则需要判断该id是否存在
        //判断组织机构是否存在
        if (ObjectUtil.isNotNull(req.getOrgId())){
            pubOrgService.PubOrgExist(req.getOrgId());
        }
        //(如果传其他不是数据库字段参数或者排序规则不是deac或者asc可能会出现错误)
        if (ObjectUtil.isNotNull(req.getColumn()) && !req.getColumn().trim().isEmpty() &&
                (req.getOrder().equalsIgnoreCase("asc")|| req.getOrder().equalsIgnoreCase("desc")) &&
                ObjectUtil.isNotNull(req.getOrder()) && !req.getOrder().trim().isEmpty()) {
            //修改字段，和数据库字段进行统一
            req.setColumn(req.getColumn().replaceAll("[A-Z]", "_$0").toLowerCase());
            req.setOrder(req.getOrder().toLowerCase());
        }
        LambdaQueryWrapper<InventorySummary> wp = createWrapper(req);//取出仓库中总数并计算
        List<InventorySummary> list = list(wp);
        long size = list(wp).size();

//        Page<InventorySummary> sumList= this.page(PageFactory.getDefaultPage(req.getPageNo(),req.getPageSize()),wp);
//        List<InventorySummary> records = sumList.getRecords();

        List<InventorySummary> collect = list.stream().map(data -> {
            Inventory inventory = inventoryService.list(new LambdaQueryWrapper<Inventory>()
                    .eq(Inventory::getOrgId, data.getOrgId())
                    .eq(Inventory::getSizeId, data.getSizeId())
                    .eq(Inventory::getTypeId, data.getTypeId())).get(0);
            //教学使用说明
            String instructions = equipmentSizeService.getOne(new LambdaQueryWrapper<EquipmentSize>()
                    .eq(EquipmentSize::getId, data.getSizeId())).getInstructions();
            data.setInstructions(instructions);
            data.setWarrantyPeriod(inventory.getWarrantyPeriod());
            data.setMaintenancePeriod(inventory.getMaintenancePeriod());
            String photo = equipmentSizeService.getOne(new LambdaQueryWrapper<EquipmentSize>().eq(EquipmentSize::getId,inventory.getSizeId())).getPhoto();
            data.setPhoto(photo);
            return data;
        }).collect(Collectors.toList());
        //对该装备typeId进行排序
        Collections.sort(collect, new Comparator<InventorySummary>() {
            @Override
            public int compare(InventorySummary o1, InventorySummary o2) {
                return o1.getTypeId().compareTo(o2.getTypeId());
            }
        });
        Page<InventorySummary> page1 = PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize());
        page1.setRecords(collect);
        page1.setTotal(size);
        return PageResultFactory.createPageResult(page1);
    }

    /**
     * 用于出库单中的装备选择
     * @return
     */
    @Override
    public List<InventorySumDto> GetInventorySumInfo(InventorySumReq req) {

        return inventorySummaryMapper.GetInventorySumInfo(req);
    }

    //处理本地主机返回单据结果
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean processInventoryRecords(RabbitMqOrderReq req) {
        //将主单据信息复制进行更新
        OrderMain orderMain = new OrderMain();
        BeanPlusUtil.copyProperties(req.getOrderMainReq(),orderMain);
        orderMainService.updateById(orderMain);

        //将子单据信息复制进行更新
        OrderDetail orderDetail = new OrderDetail();
        BeanPlusUtil.copyProperties(req.getOrderDetailReq(),orderDetail);
        orderDetailService.updateById(orderDetail);

        ////对装备表进行更新或者添加
        //新增列表
        List<Inventory> addList = new ArrayList<>();
        //更新列表
        List<Inventory> updateList = new ArrayList<>();
        //出库out，入库in
        String orderType=orderMain.getOrderType();
        //组织机构
        Long orgId;
        if (orderType.equals("in")){
            orgId=orderMain.getEndOrgId();
        }else {
            orgId=orderMain.getStartOrgId();
        }
        //将具体Epc进行处理（判断装备是否具有id，如果没有id表示新增一条数据在数据库中--采购）
        req.getInventoryReqList().forEach(inventoryReq -> {
            Inventory inventory = new Inventory();
            BeanPlusUtil.copyProperties(inventoryReq,inventory);
            inventory.setOrgId(orgId);
            //新增装备
            if (ObjectUtil.isNull(inventory.getId())){
                //修改状态
                inventory.setId(UUID.randomUUID().toString());
                inventory.setLocationState(orderMain.getOrderType());
                inventory.setBussinessState("normal");
                inventory.setState("normal");
                addList.add(inventory);
            }else {
                //修改状态
                inventory.setLocationState(orderMain.getOrderType());
                //修改业务状态
                if (orderType.equals("in")){
                    inventory.setBussinessState("normal");
                    inventory.setState("normal");
                }else if (orderType.equals("out") && orderMain.getBussinessType().equals("repair")){
                    inventory.setBussinessState(orderMain.getBussinessType());
                    inventory.setState("fix");
                }else if (orderType.equals("out") && orderMain.getBussinessType().equals("remove")){
                    inventory.setBussinessState(orderMain.getBussinessType());
                    inventory.setState("destory");
                }else {
                    inventory.setBussinessState(orderMain.getBussinessType());
                    inventory.setState("normal");
                }
                updateList.add(inventory);
            }
        });
        boolean b=false;
        if (ObjectUtil.isNotNull(addList) && addList.size()>0){
            b = inventoryService.saveBatch(addList);
        }
        if (ObjectUtil.isNotNull(updateList) && updateList.size()>0){
            b = inventoryService.updateBatchById(updateList);
        }
        //对装备进行记录，存入log表形成出入库记录
        Boolean c = insertLog(req,orderMain,addList,updateList);
//        Boolean d = updateSummaryInsByOrder(orgId);
        return (b && c );
    }
    

    //对装备进行记录，存入log表形成出入库记录
    @Transactional(rollbackFor = Exception.class)
    public Boolean insertLog(RabbitMqOrderReq req,OrderMain orderMain,List<Inventory> addList,List<Inventory> updateList ){
        //插入log_summary
        LogSummary logSummary = new LogSummary();
        logSummary.setDevice(req.getDevice());
        logSummary.setDeviceType(req.getDeviceType());
        logSummary.setLocationType(0);
        logSummary.setUserName(req.getUserName());
        logSummary.setUseTime(req.getUseTime());
//        logSummary.setLocationId();
//        logSummary.setLocationName();
        if (orderMain.getOrderType().equals("in")){
            logSummary.setOutInState("in");
            logSummary.setOrgId(orderMain.getEndOrgId());
            logSummary.setOrgName(orderMain.getEndOrgName());
        }else {
            logSummary.setOutInState("out");
            logSummary.setOrgId(orderMain.getStartOrgId());
            logSummary.setOrgName(orderMain.getStartOrgName());
        }
        logSummary.setOrderMainId(orderMain.getId());
        logSummary.setOrderCode(orderMain.getOrderCode());
        logSummary.setBussinessType(orderMain.getBussinessType());
        boolean a = logSummaryService.save(logSummary);
        //存入log_detail表中
        List<LogDetail> logDetailList=new ArrayList<>();
        //判断是哪个列表不为空，进行出入库记录
        if (addList.size()!=0 && ObjectUtil.isNotNull(addList)){
            for (Inventory inventory:addList) {
                LogDetail logDetail = new LogDetail();
                BeanPlusUtil.copyProperties(inventory,logDetail);
                logDetail.setInventoryId(inventory.getId());
                logDetail.setBussinessType(orderMain.getBussinessType());
                logDetail.setOutInState(orderMain.getOrderType());
                logDetail.setOrderCode(orderMain.getOrderCode());
                logDetail.setSummaryId(logSummary.getId());
                logDetail.setOrderMainId(orderMain.getId());
                logDetail.setErrorState(0);
                logDetailList.add(logDetail);
            }
        }
        if (updateList.size()!=0 && ObjectUtil.isNotNull(updateList)){
            for (Inventory inventory:updateList) {
                LogDetail logDetail = new LogDetail();
                BeanPlusUtil.copyProperties(inventory,logDetail);
                logDetail.setOutInState(orderMain.getOrderType());
                logDetail.setSummaryId(logSummary.getId());
                logDetail.setOrderMainId(orderMain.getId());
                logDetailList.add(logDetail);
            }
        }
        boolean b = logDetailService.saveBatch(logDetailList);
        return (a && b);
    }

    //对summary表中数据进行重新计算装备信息汇总
    public Boolean updateSummaryInsByOrder(Long orgId){
        //查询字典表中的临近报废天数
        SysDictItem sysDictItem = sysDictItemService.getOne(new LambdaQueryWrapper<SysDictItem>()
                .eq(SysDictItem::getItemText, "brokenNumber"));
        //如果配置找不到，那就默认设置为15天为临近报废（如果装备的质保期小于15天了，就是为临近报废）
        Integer brokenNumberDays;
        if (ObjectUtil.isNotNull(sysDictItem)){
            brokenNumberDays=15;
        }else {
            brokenNumberDays=Integer.parseInt(sysDictItem.getItemValue());
        }
        //查询出组织机构下的所有仓库信息，并且将表中的仓库信息数据进行删除
        List<WarehouseDto> allWarehouse = warehouseService.getAllWarehouse(orgId);
        boolean a = inventorySummaryMapper.deleteByWarehouse(allWarehouse);
        //根据仓库id重新计算汇总信息
        boolean sumByWarehouse = inventorySummaryMapper.getSumByWarehouse(allWarehouse, brokenNumberDays);
        return (a && sumByWarehouse);
    }

    //单警柜返回数据
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean cabinetInOutRecords(CabinetInOutRecordsReq req) {
        //批量修改装备信息
        List<InventoryReq> inventoryList = req.getInventoryList();
        boolean a=true;
        List<Inventory> inventoryLogsList=new ArrayList<>();
        for (InventoryReq inventoryReq:inventoryList) {
            Inventory inventory = new Inventory();
            BeanPlusUtil.copyProperties(inventoryReq,inventory);
            boolean result = inventoryService.saveOrUpdate(inventory);
            inventoryLogsList.add(inventory);
            if (!result){
                a=false;
                break;
            }
        }
        //修改summary表中数据
//        boolean b = updateSummaryInsByCabinet(req.getLocationId());
        //添加日志记录、
        Boolean c = insertCabinetLog(req,inventoryLogsList);
        return (a  && c);
    }


    public boolean updateSummaryInsByCabinet(String locationId){
        //查询字典表中的临近报废天数
        SysDictItem sysDictItem = sysDictItemService.getOne(new LambdaQueryWrapper<SysDictItem>()
                .eq(SysDictItem::getItemText, "brokenNumber"));
        //如果配置找不到，那就默认设置为15天为临近报废（如果装备的质保期小于15天了，就是为临近报废）
        Integer brokenNumberDays;
        if (ObjectUtil.isNotNull(sysDictItem)){
            brokenNumberDays=15;
        }else {
            brokenNumberDays=Integer.parseInt(sysDictItem.getItemValue());
        }
        //根据箱门id查询出单警柜信息
        CabinetBox cabinetBox = cabinetBoxService.getById(locationId);
        //删除inventorysummary表中该单警柜数据
        boolean a = inventorySummaryMapper.deleteByCabinet(cabinetBox.getCabinetId());
        //重新计算该单警柜下面的装备信息
        boolean b = inventorySummaryMapper.getSumByCabinet(cabinetBox.getCabinetId(),brokenNumberDays);
        return (a && b);
    }

    //添加单警柜出入库记录日志
    public Boolean insertCabinetLog(CabinetInOutRecordsReq req,List<Inventory> inventoryLogsList){

        LogSummary logSummary = new LogSummary();
        BeanPlusUtil.copyProperties(req,logSummary);
        logSummary.setLocationType(1);
        boolean a = logSummaryService.save(logSummary);
        List<LogDetail> logDetailList=new ArrayList<>();
        for (Inventory inventory:inventoryLogsList) {
            LogDetail logDetail = new LogDetail();
            BeanPlusUtil.copyProperties(inventory,logDetail);
            logDetail.setInventoryId(inventory.getId());
            logDetail.setCabinetboxId(req.getLocationId());
            logDetail.setOutInState(inventory.getLocationState());
            logDetail.setSummaryId(logSummary.getId());
            logDetailList.add(logDetail);
        }
        boolean b = logDetailService.saveBatch(logDetailList);
        return (a && b);
    }

    //根据组织机构id/单警柜id/仓库id查询出库存汇总数量以及金额
    @Override
    public List<InventorySummary> getTotalNumberAndPrice(InventorySumReq req) {
        List<InventorySummary> list=new ArrayList<>();
        InventorySummary totalNumberAndPrice = inventorySummaryMapper.getTotalNumberAndPrice(req);
        if (ObjectUtil.isNotNull(totalNumberAndPrice)){
            list.add(totalNumberAndPrice);
        }
        return list;
    }


    //计算装备总数（装备数量数据统计）
    @Override
    public List<InventorySummary> EquipmentStatistics(InventorySumReq req) {
        List<InventorySummary> inventorySummaryList=new ArrayList<>();
        InventorySummary inventorySummary = inventorySummaryMapper.EquipmentStatistics(req);
        if (ObjectUtil.isNotNull(inventorySummary)){
            inventorySummaryList.add(inventorySummary);
        }
        return inventorySummaryList;
    }

    private LambdaQueryWrapper<InventorySummary> createWrapper(InventorySumReq req) {
        LambdaQueryWrapper<InventorySummary> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
        /**
         * 判断是否有高级搜索，如果有则进行添加查询条件
         */
        if (ObjectUtil.isNotNull(req.getNumber())){
            //将值进行切割，> = <并将其判断为哪个符号，如果为>则使用ge，=为eq，<为le
            String symbol = req.getNumber().substring(0, 1);
            String value = req.getNumber().substring(1);
            if (symbol.equals(">")){
                wrapper.gt(InventorySummary::getNumber,value);
            } else if (symbol.equals("=")) {
                wrapper.eq(InventorySummary::getNumber,value);
            }else if (symbol.equals("<")){
                wrapper.lt(InventorySummary::getNumber,value);
            }
        }
        if (ObjectUtil.isNotNull(req.getStockNumber())){
            String symbol = req.getStockNumber().substring(0, 1);
            String value = req.getStockNumber().substring(1);
            if (symbol.equals(">")){
                wrapper.gt(InventorySummary::getStockNumber,value);
            } else if (symbol.equals("=")) {
                wrapper.eq(InventorySummary::getStockNumber,value);
            }else if (symbol.equals("<")){
                wrapper.lt(InventorySummary::getStockNumber,value);
            }
        }
        if (ObjectUtil.isNotNull(req.getOutboundNumber())){
            String symbol = req.getOutboundNumber().substring(0, 1);
            String value = req.getOutboundNumber().substring(1);
            if (symbol.equals(">")){
                wrapper.gt(InventorySummary::getOutboundNumber,value);
            } else if (symbol.equals("=")) {
                wrapper.eq(InventorySummary::getOutboundNumber,value);
            }else if (symbol.equals("<")){
                wrapper.lt(InventorySummary::getOutboundNumber,value);
            }
        }
        if (ObjectUtil.isNotNull(req.getExpireNumber())){
            String symbol = req.getExpireNumber().substring(0, 1);
            String value = req.getExpireNumber().substring(1);
            if (symbol.equals(">")){
                wrapper.gt(InventorySummary::getExpireNumber,value);
            } else if (symbol.equals("=")) {
                wrapper.eq(InventorySummary::getExpireNumber,value);
            }else if (symbol.equals("<")){
                wrapper.lt(InventorySummary::getExpireNumber,value);
            }
        }
        if (ObjectUtil.isNotNull(req.getBrokenNumber())){
            String symbol = req.getBrokenNumber().substring(0, 1);
            String value = req.getBrokenNumber().substring(1);
            if (symbol.equals(">")){
                wrapper.gt(InventorySummary::getBrokenNumber,value);
            } else if (symbol.equals("=")) {
                wrapper.eq(InventorySummary::getBrokenNumber,value);
            }else if (symbol.equals("<")){
                wrapper.lt(InventorySummary::getBrokenNumber,value);
            }
        }
        if (ObjectUtil.isNotNull(req.getUnitPrice())){
            String symbol = req.getUnitPrice().substring(0, 1);
            String value = req.getUnitPrice().substring(1);
            if (symbol.equals(">")){
                wrapper.gt(InventorySummary::getUnitPrice,value);
            } else if (symbol.equals("=")) {
                wrapper.eq(InventorySummary::getUnitPrice,value);
            }else if (symbol.equals("<")){
                wrapper.lt(InventorySummary::getUnitPrice,value);
            }
        }
        if (ObjectUtil.isNotNull(req.getPrice())){
            String symbol = req.getPrice().substring(0, 1);
            String value = req.getPrice().substring(1);
            if (symbol.equals(">")){
                wrapper.gt(InventorySummary::getPrice,value);
            } else if (symbol.equals("=")) {
                wrapper.eq(InventorySummary::getPrice,value);
            }else if (symbol.equals("<")){
                wrapper.lt(InventorySummary::getPrice,value);
            }
        }
        //根据组织机构号查询
        wrapper.eq(ObjectUtil.isNotEmpty(req.getOrgId()), InventorySummary::getOrgId, req.getOrgId());
        //根据组织机构名模糊查询
        wrapper.like(ObjectUtil.isNotEmpty(req.getOrgName()), InventorySummary::getOrgName, req.getOrgName());
        //位置id（单警柜/仓库）
        wrapper.eq(ObjectUtil.isNotEmpty(req.getLocationId()), InventorySummary::getLocationId, req.getLocationId());
        //位置类型
        wrapper.eq(ObjectUtil.isNotEmpty(req.getLocationType()),InventorySummary::getLocationType,req.getLocationType());
        //位置信息
        wrapper.like(ObjectUtil.isNotEmpty(req.getLocationName()), InventorySummary::getLocationName, req.getLocationName());
        //装备类别名称
        wrapper.like(ObjectUtil.isNotEmpty(req.getTypeName()), InventorySummary::getTypeName, req.getTypeName());
        //根据类别
        wrapper.eq(ObjectUtil.isNotEmpty(req.getTypeId()), InventorySummary::getTypeId, req.getTypeId());
        //型号名称
        wrapper.like(ObjectUtil.isNotEmpty(req.getSizeName()), InventorySummary::getSizeName, req.getSizeName());
        //号型
        wrapper.eq(ObjectUtil.isNotEmpty(req.getSizeId()), InventorySummary::getSizeId, req.getSizeId());
        wrapper.last("order by " + req.getColumn() + " " + req.getOrder());

        return wrapper;
    }
}
