package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.req.DestoryUnitReq;
import com.junmp.jyzb.api.bean.req.ManufacturerReq;
import com.junmp.jyzb.api.exception.enums.DestoryUnitExceptionEnum;
import com.junmp.jyzb.api.exception.enums.ManufacturerExceptionEnum;
import com.junmp.jyzb.entity.DestoryUnit;
import com.junmp.jyzb.entity.Manufacturer;
import com.junmp.jyzb.service.DestoryUnitService;
import com.junmp.jyzb.mapper.DestoryUnitMapper;
import com.junmp.jyzb.utils.DateTimeUtil;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
* @author lxh专属坐骑
* @description 针对表【base_destory_unit(报废收物单位表)】的数据库操作Service实现
* @createDate 2023-10-16 09:35:03
*/
@Service
public class DestoryUnitServiceImpl extends ServiceImpl<DestoryUnitMapper, DestoryUnit>
    implements DestoryUnitService{


    @Override
    public String addDestoryUnit(DestoryUnitReq req) {
        //判断是否已经存在短码，如果存在则不再允许添加成功
        DestoryUnit one = getOne(new LambdaQueryWrapper<DestoryUnit>().eq(DestoryUnit::getCode, req.getName()));
        if (ObjectUtil.isNotNull(one)){
            throw new ServiceException(DestoryUnitExceptionEnum.DESTORYUNIT_IS_EXIST);
        }
        DestoryUnit destoryUnit = new DestoryUnit();
        BeanPlusUtil.copyProperties(req,destoryUnit);
        destoryUnit.setCreateTime(DateTimeUtil.getCurrentDateTime());
        save(destoryUnit);
        return destoryUnit.getId();
    }

    @Override
    public boolean updateDestoryUnit(DestoryUnitReq req) {
        DestoryUnit destoryUnit = new DestoryUnit();
        BeanPlusUtil.copyProperties(req,destoryUnit);
        destoryUnit.setUpdateTime(DateTimeUtil.getCurrentDateTime());
        return updateById(destoryUnit);
    }

    @Override
    public List<DestoryUnit> showDestoryUnitList(DestoryUnitReq req) {
        LambdaQueryWrapper<DestoryUnit> wrapper = createWrapper(req);
        return  list(wrapper);
    }

    @Override
    public PageResult<DestoryUnit> showDestoryUnitPage(DestoryUnitReq req) {
        LambdaQueryWrapper<DestoryUnit> wrapper = createWrapper(req);
        Page<DestoryUnit> page = page(PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize()), wrapper);
        return PageResultFactory.createPageResult(page);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean delDestoryUnit(DestoryUnitReq req) {
        //抛出异常，销毁、报废单位未选中
        if (req.getDeleteList().size()==0){
            throw new ServiceException(DestoryUnitExceptionEnum.DESTORYUNIT_NOT_CHOOSE);
        }
        //查询出全部的销毁、报废单位
        Set<String> collect = list().stream().map(DestoryUnit::getId).collect(Collectors.toSet());
        Set<String> delList=new HashSet<>(req.getDeleteList());
        if (collect.containsAll(delList)){
            return removeBatchByIds(req.getDeleteList());
        }else {
            throw new ServiceException(DestoryUnitExceptionEnum.DESTORYUNIT_NOT_EXIST);
        }
    }

    private LambdaQueryWrapper<DestoryUnit> createWrapper(DestoryUnitReq req){
        LambdaQueryWrapper<DestoryUnit> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)){
            return wrapper;
        }
        wrapper.eq(ObjectUtil.isNotNull(req.getId()),DestoryUnit::getId,req.getId());
        wrapper.eq(ObjectUtil.isNotNull(req.getState()),DestoryUnit::getState,req.getState());
        wrapper.like(ObjectUtil.isNotNull(req.getName()),DestoryUnit::getName,req.getName());
        wrapper.like(ObjectUtil.isNotNull(req.getShortName()),DestoryUnit::getShortName,req.getShortName());
        wrapper.like(ObjectUtil.isNotNull(req.getContacts()),DestoryUnit::getContacts,req.getContacts());
        wrapper.orderByDesc(DestoryUnit::getCreateTime);
        return wrapper;
    }
}




