package com.junmp.jyzb.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.junmpProcess.dto.StartProcessInstanceDTO;
import com.junmp.junmpProcess.service.IFlowInstanceService;
import com.junmp.jyzb.api.bean.dto.BusFormDto;
import com.junmp.jyzb.api.bean.query.QueryBusFormReq;
import com.junmp.jyzb.api.bean.req.UpdateBusFormReq;
import com.junmp.jyzb.api.exception.enums.OrderExceptionEnum;
import com.junmp.jyzb.entity.BusForm;
import com.junmp.jyzb.entity.OrderNum;
import com.junmp.jyzb.service.BusFormService;
import com.junmp.jyzb.mapper.BusFormMapper;
import com.junmp.jyzb.service.StocktakeService;
import com.junmp.jyzb.utils.DateTimeUtil;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import com.junmp.v2.sys.user.entity.SysUserOrg;
import com.junmp.v2.sys.user.service.SysUserOrgService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

/**
* @author lxh专属坐骑
* @description 针对表【base_bus_form】的数据库操作Service实现
* @createDate 2023-09-25 10:16:46
*/
@Service
public class BusFormServiceImpl extends ServiceImpl<BusFormMapper, BusForm> implements BusFormService{
    @Resource
    public StocktakeService stocktakeService;

    @Resource
    private IFlowInstanceService FlowInstanceService;

    @Resource
    private SysUserOrgService sysUserOrgService;

    /**
     * 创建业务单
     * @param req
     * @return
     */
    @Override
    public String AddBussinessOrder(UpdateBusFormReq req) {
        BusForm busForm = new BusForm();
        BeanUtil.copyProperties(req,busForm);

        if (ObjectUtil.isNull(req.getId())){
            String id= UUID.randomUUID().toString();
            busForm.setId(id);
            //设置单据号（调拨的单号根据和登录人员的组织机构id有关）
            //根据userId去查询组织机构id
            OrderNum orderNum=new OrderNum();
            if (req.getBussinessType().equals("allocate")){
                if (req.getStartOrgId() == req.getOrgId()){
                    orderNum = stocktakeService.setOrderCode(req.getBussinessType(), req.getStartOrgId());
                } else {
                    orderNum = stocktakeService.setOrderCode(req.getBussinessType(), req.getEndOrgId());
                }
            }else {
                orderNum = stocktakeService.setOrderCode(req.getBussinessType(), req.getOrgId());
            }
            String codeValue=String.format("%04d",orderNum.getNum());
            busForm.setBussinessCode(orderNum.getBussinessType()+orderNum.getYear()+
                    String.format("%02d",LocalDateTime.now().getMonth().getValue())+
                    String.format("%02d",LocalDateTime.now().getDayOfMonth())+codeValue);

            busForm.setCreateTime(DateTimeUtil.getCurrentDateTime());
        }

        //执行工作流
        if (req.getExamineState().equals("working"))
        {
            StartProcessInstanceDTO startProcessInstanceDTO=new StartProcessInstanceDTO();
            startProcessInstanceDTO.setProcessDefinitionId(req.getProcessDefinitionId());
            startProcessInstanceDTO.setOrderId(busForm.getId());
            startProcessInstanceDTO.setOrderType("bussinessOrder");
            startProcessInstanceDTO.setUserId(req.getApplyUserId());
            String ProcessInstanceId= FlowInstanceService.startProcessInstanceById(startProcessInstanceDTO);
            busForm.setProcessId(ProcessInstanceId);

        }

        if(ObjectUtil.isNotNull(req.getId())){
            //已经是一个草稿，在点击提交的时候只需要更新即可，因为数据库中已经存在该单据
            updateById(busForm);
        }else {
            //保存
            this.save(busForm);
        }
        return busForm.getId();
    }

    /**
     * 修改业务单
     * @param req
     * @return
     */
    @Override
    public boolean UpdateBussinessOrder(UpdateBusFormReq req) {
        BusForm busForm = getById(req.getId());
        if (!busForm.getExamineState().equals("none")){
            throw new ServiceException(OrderExceptionEnum.ORDER_CAN_NOT_UPDATE);
        }
        BeanPlusUtil.copyProperties(req,busForm);
        busForm.setUpdateTime(DateTimeUtil.getCurrentDateTime());
        return updateById(busForm);
    }

    /**
     * 查询业务单，（可以根据业务单进行修改）
     * @param req
     * @return
     */
    @Override
    public PageResult<BusFormDto> showBussinessOrder(QueryBusFormReq req) {
        //(如果传其他不是数据库字段参数或者排序规则不是deac或者asc可能会出现错误)
        if (ObjectUtil.isNotNull(req.getColumn()) && !req.getColumn().trim().isEmpty() &&
                (req.getOrder().equalsIgnoreCase("asc")|| req.getOrder().equalsIgnoreCase("desc")) &&
                ObjectUtil.isNotNull(req.getOrder()) && !req.getOrder().trim().isEmpty()) {
            //修改字段，和数据库字段进行统一
            req.setColumn(req.getColumn().replaceAll("[A-Z]", "_$0").toLowerCase());
            req.setOrder(req.getOrder().toLowerCase());
        }
        LambdaQueryWrapper<BusForm> eq = new LambdaQueryWrapper<BusForm>()
                //单据类型
                .eq(ObjectUtil.isNotNull(req.getBussinessType()), BusForm::getBussinessType, req.getBussinessType())
                //审核状态
                .eq(ObjectUtil.isNotNull(req.getExamineState()) && !req.getExamineState().trim().isEmpty(), BusForm::getExamineState, req.getExamineState())
                //仓库id
                .eq(ObjectUtil.isNotNull(req.getWarehouseId()), BusForm::getWarehouseId, req.getWarehouseId())
                .eq(ObjectUtil.isNotNull(req.getOrgId()),BusForm::getOrgId,req.getOrgId())
                .ge(ObjectUtil.isNotNull(req.getStartTime()), BusForm::getCreateTime, req.getStartTime())
                .le(ObjectUtil.isNotNull(req.getEndTime()), BusForm::getCreateTime, req.getEndTime())
                .last("order by " + req.getColumn() + " " + req.getOrder());
        long size = list(eq).size();
        Page<BusForm> page = page(PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize()), eq);
        List<BusFormDto> collect = page.getRecords().stream().map(busForm -> {
            BusFormDto busFormDto = new BusFormDto();
            BeanPlusUtil.copyProperties(busForm, busFormDto);
            return busFormDto;
        }).collect(Collectors.toList());
        Page<BusFormDto> page1=new Page<>(req.getPageNo(),req.getPageSize());
        page1.setRecords(collect);
        page1.setTotal(size);
        return PageResultFactory.createPageResult(page1);
    }
}




