package com.junmp.jyzb.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.junmp.jyzb.api.bean.query.PolicemanFingerReq;
import com.junmp.jyzb.api.bean.req.UpdatePoliceFingerReq;
import com.junmp.jyzb.entity.PoliceFinger;
import com.junmp.v2.db.api.page.PageResult;

import java.util.List;
import java.util.Map;


public interface PoliceFingerService extends IService<PoliceFinger> {

    /**
     * 新增指纹信息
     * @param req
     * @return
     */
    Integer addFingerInfo(UpdatePoliceFingerReq req);

    /**
     * 更新指纹信息
     * @param req
     * @return
     */
    boolean updateFingerInfo(UpdatePoliceFingerReq req);

    /**
     * 查询指纹信息列表
     * @param req
     * @return
     */
    List<PoliceFinger> searchFingerInfo(PolicemanFingerReq req);

    /**
     * 删除指纹信息
     * @param req
     * @return
     */
    boolean deleteFinger(UpdatePoliceFingerReq req);


    /**
     * 分页信息
     * @param req
     * @return
     */
    PageResult<PoliceFinger> findPage(PolicemanFingerReq req);
}
