package com.junmp.jyzb.rabbitmq;

import com.junmp.jyzb.api.bean.req.RabbitMqOrderReq;
import com.junmp.jyzb.service.InventorySummaryService;
import com.rabbitmq.client.Channel;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.support.AmqpHeaders;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.io.IOException;

/**
 * 装备出入库消息的监听
 */
@Component

public class OrderMQReceiver {

    @Resource
    private InventorySummaryService inventorySummaryService;

    @RabbitListener(queues = "11111")//监听队列名
    private void a(RabbitMqOrderReq req, Channel channel, @Header(AmqpHeaders.DELIVERY_TAG) long deliveryTag){

        try {
            System.out.println("req = " + req);
            //将消息进行消费
            Boolean result = inventorySummaryService.processInventoryRecords(req);
            if (result){
                // 手动确认消息
                channel.basicAck(deliveryTag, false);
            }else {
                channel.basicNack(deliveryTag, false, true);
            }
            // 手动确认消息
            channel.basicAck(deliveryTag, false);
        } catch (Exception e) {
            // 处理消息过程中发生异常，拒绝消息并将其重新放回队列
            try {
                channel.basicNack(deliveryTag, false, true);
            } catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}
