package com.junmp.jyzb.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.junmp.jyzb.api.bean.dto.ProductTagDto;
import com.junmp.jyzb.api.bean.dto.SimpleTagDto;
import com.junmp.jyzb.entity.ProductTag;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/7/30 13:45
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Mapper
public interface ProductTagMapper extends BaseMapper<ProductTag> {

    /**
     * 从指定批次取一条未生成的标签数据
     *
     * @param batchId 批次号
     */
    SimpleTagDto getInitTagInfo(@Param("batchId") Long batchId);

    /**
     * 获取TAG
     */
    ProductTagDto getTagInfoByTagId(@Param("tagId") Long tagId);
}
