package com.junmp.jyzb.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.junmp.jyzb.api.bean.dto.InventorySumDto;
import com.junmp.jyzb.api.bean.dto.WarehouseDto;
import com.junmp.jyzb.api.bean.query.InventorySumReq;
import com.junmp.jyzb.entity.InventorySummary;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface InventorySummaryMapper  extends BaseMapper<InventorySummary> {

    //用于出库单中的装备选择
    List<InventorySumDto> GetInventorySumInfo(@Param("req") InventorySumReq req);

    //根据仓库id删除装备汇总信息
    boolean deleteByWarehouse(@Param("list") List<WarehouseDto> allWarehouse);

    boolean getSumByWarehouse(@Param("list") List<WarehouseDto> allWarehouse,@Param("brokenNumberDays")Integer brokenNumberDays);

    //根据单警柜删除装备汇总信息
    boolean deleteByCabinet(@Param("cabinetId") String cabinetId);

    boolean getSumByCabinet(@Param("cabinetId") String cabinetId,@Param("brokenNumberDays")Integer brokenNumberDays);

    InventorySummary getTotalNumberAndPrice(@Param("req") InventorySumReq req);

    InventorySummary EquipmentStatistics(@Param("req") InventorySumReq req);
}