package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 警员调岗申请单
 * @TableName bussiness_reassignment
 */
@TableName(value ="bussiness_reassignment")
@AllArgsConstructor
@NoArgsConstructor
@Data
public class Reassignment implements Serializable {
    /**
     * id
     */

    private String id;

    /**
     * 工作流id
     */
    @TableField(value = "process_id")
    private String processId;

    /**
     * 调岗警员id
     */
    @TableField(value = "police_id")
    private String policeId;

    /**
     * 调岗警员姓名
     */
    @TableField(value = "police_name")
    private String policeName;

    /**
     * 警员带走装备
     */
    @TableField(value = "eqs_list")
    private String eqsList;

    /**
     * 组织机构id（谁申请，就是谁的组织机构号）
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 目标组织机构id
     */
    @TableField(value = "target_org_id")
    private Long targetOrgId;

    /**
     * 调岗原因
     */
    @TableField(value = "note")
    private String note;

    /**
     * 审核状态(none未接入工作流，working审批中，finished审批完成)
     */
    @TableField(value = "examine_state")
    private String examineState;

    /**
     * 申请时间
     */
    @TableField(value = "apply_time")
    private Date applyTime;
    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(value = "update_time")
    private Date updateTime;

    /**
     * 创建人员
     */
    @TableField(value = "create_user")
    private String createUser;

    /**
     * 更新人员
     */
    @TableField(value = "update_user")
    private String updateUser;

    private static final long serialVersionUID = 1L;

}