package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.dto.TjOrgEqsDto;
import com.junmp.jyzb.api.bean.query.InventoryReq;
import com.junmp.jyzb.service.InventoryService;
import com.junmp.jyzb.service.PubOrgService;
import com.junmp.jyzb.service.TjService;
import com.junmp.v2.common.bean.response.ApiRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@RestController
@Slf4j
@RequestMapping("/Tj")
@Api(tags = "统计报表模块")
public class TjController {

   @Resource
   private TjService tjService;

    /**
     * 根据组织机构统计装备的报表数据
     */
    @PostMapping("/TjOrgEqs")
    @ApiOperation("/装备统计报表")
    public ApiRes<List<TjOrgEqsDto>> TjOrgEqs(@RequestBody InventoryReq req){
        return ApiRes.success(tjService.showOrgList(req.getOrgId(),true));
    }
}
