package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.req.RabbitMqOrderReq;
import com.junmp.jyzb.service.TestService;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.v2.common.bean.response.ApiRes;
import io.swagger.annotations.ApiOperation;
import liquibase.pro.packaged.B;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@RestController
@Slf4j
@RequestMapping("/api")
public class TestController {

    @Resource
    private TestService testService;
    @RequestMapping("/hello")
    public ResponseResult Hello(){
        return new ResponseResult(10000,"操作成功","hello");
    }

    @PostMapping("/test")
    public ApiRes<Boolean> test(@RequestBody RabbitMqOrderReq req){
        return ApiRes.success(testService.test(req));
    }

}
