package com.junmp.jyzb.controller;

import cn.hutool.core.util.ObjectUtil;
import com.junmp.jyzb.api.bean.query.StocktakeReq;
import com.junmp.jyzb.api.bean.req.UpdateStocktakeReq;
import com.junmp.jyzb.entity.Stocktake;
import com.junmp.jyzb.service.StocktakeService;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@RestController
@Slf4j
@Api(tags ="盘库管理")
@RequestMapping("/Stocktake")
public class StocktakeController {

    @Resource
    private StocktakeService stocktakeService;

    //盘库申请
    @PostMapping("/AddStocktakeOrder")
    @ApiOperation("盘库申请")
    public ApiRes<String> AddStocktakeOrder (@RequestBody @Validated(ValidationApi.add.class) UpdateStocktakeReq req){
        //判断是否有工作流id，如果有则将状态进行修改
        if (ObjectUtil.isEmpty(req.getProcessDefinitionId()))
        {
            req.setExamineState("none");
        }
        else
        {
            req.setExamineState("working");
        }
        return ApiRes.success(stocktakeService.AddStocktakeOrder(req));
    }

    //查询单据
    @PostMapping("/ShowStocktakeOrderPage")
    @ApiOperation("盘库单据查询")
    public ApiRes<PageResult<Stocktake>> ShowStocktakeOrderPage(@RequestBody @Validated(ValidationApi.edit.class)StocktakeReq req){
        return ApiRes.success(stocktakeService.ShowStocktakeOrderPage(req));
    }

    //修改单据
    @PostMapping("/UpdateStocktakeOrder")
    @ApiOperation("修改盘库业务单")
    public ApiRes<Boolean> UpdateStocktakeOrder(@RequestBody @Validated(ValidationApi.edit.class) UpdateStocktakeReq req) {
        return ApiRes.success(stocktakeService.UpdateStocktakeOrder(req));
    }

}
