package com.junmp.jyzb.controller;


import cn.hutool.core.util.StrUtil;
import com.junmp.jyzb.api.constant.JYZBConstant;
import com.junmp.jyzb.cache.GoldRedisCache;
import com.junmp.jyzb.doc.LoginDoc;
import com.junmp.v2.auth.api.bean.auth.LoginReq;
import com.junmp.v2.auth.api.bean.auth.LoginRes;
import com.junmp.v2.auth.sign.AuthContainer;
import com.junmp.v2.common.bean.response.ApiRes;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * <pre>
 *
 * 描述：登录服务
 * 版本：1.0.0
 * 日期：2022/6/7 13:47
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Slf4j
@RestController
@RequestMapping("/api")
public class LoginController implements LoginDoc {

    @Resource
    private AuthContainer authContainer;


    @Resource
    private GoldRedisCache goldRedisCache ;


    @PostMapping(name = "用户登录", path = "/auth/login")
    public ApiRes<LoginRes> login(@RequestBody LoginReq req) {
        LoginRes res = authContainer.login(req);
        if (null != res) {
            //配置扩展信息
            String jwt = goldRedisCache.get(JYZBConstant.JYZB_JWT_KEY);
            if(StrUtil.isEmpty(jwt)){
                goldRedisCache.put(JYZBConstant.JYZB_JWT_KEY,res.getToken());
            }
            return ApiRes.success(res);
        } else {
            return ApiRes.failure("登录失败");
        }
    }

    @PostMapping(name = "用户登出", path = "/auth/logout")
    public ApiRes<Boolean> logout(){
        authContainer.logout();
        log.info("登出成功");
        return ApiRes.success();
    }
}
