package com.junmp.jyzb.api.exception.enums;

import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

@Getter
public enum RepairUnitExceptionEnum implements IExceptionEnum {
    /**
     * 删除时未选中需要删除的维修收物单位
     */
    REPAIRUNIT_NOT_CHOOSE(CommonConstant.DEFAULT_USER_ERROR_CODE,"删除时未选中需要删除的维修收物单位"),
    /**
     * 维修单位不存在
     */
    REPAIRUNIT_NOT_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE,"维修单位不存在"),
    /**
     * 维修单位已存在
     */
    REPAIRUNIT_IS_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE,"维修单位已存在"),;
    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    RepairUnitExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
