package com.junmp.jyzb.api.exception.enums;

import com.junmp.jyzb.api.constant.JYZBConstant;
import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/8/1 13:08
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Getter
public enum ProductExceptionEnum implements IExceptionEnum {

    /**
     * 产品信息不存在
     */
    PRODUCT_NOT_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE + JYZBConstant.JYZB_EXCEPTION_STEP_CODE + 12, "产品信息不存在"),

    /**
     * 号型信息不存在
     */
    SIZE_NOT_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE + JYZBConstant.JYZB_EXCEPTION_STEP_CODE + 12, "号型信息不存在"),

    /**
     * 产品信息不存在
     */
    PRODUCT_SKU_NOT_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE + JYZBConstant.JYZB_EXCEPTION_STEP_CODE + 13, "号型不存在"),

    /**
     * 批次信息不存在
     */
    BATCH_NOT_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE + JYZBConstant.JYZB_EXCEPTION_STEP_CODE + 14, "批次不存在"),

    /**
     * 批次信息不存在
     */
    BATCH_PROCESSED(CommonConstant.DEFAULT_USER_ERROR_CODE + JYZBConstant.JYZB_EXCEPTION_STEP_CODE + 15, "批次已生产"),

    /**
     * 批次生产已完成
     */
    BATCH_PROCESSED_DONE(CommonConstant.DEFAULT_USER_ERROR_CODE + JYZBConstant.JYZB_EXCEPTION_STEP_CODE + 16, "批次生产已完成"),

    /**
     * 批次生产已完成
     */
    MODIFY_NUM_ERROR(CommonConstant.DEFAULT_USER_ERROR_CODE + JYZBConstant.JYZB_EXCEPTION_STEP_CODE + 17, "批次生产已完成,数量不能小于原数量"),

    /**
     * 标签信息不存在
     */
    TAG_INFO_NOT_EXISTS(CommonConstant.DEFAULT_USER_ERROR_CODE + JYZBConstant.JYZB_EXCEPTION_STEP_CODE + 19, "标签信息不存在"),


    /**
     * 标签信息初始化完成
     */
    TAG_INFO_INIT_DONE(CommonConstant.DEFAULT_USER_ERROR_CODE + JYZBConstant.JYZB_EXCEPTION_STEP_CODE + 20, "检查标签信息是否绑定完成"),

    /**
     * 标签已绑定
     */
    TAG_INFO_HAD_BINDING(CommonConstant.DEFAULT_USER_ERROR_CODE + JYZBConstant.JYZB_EXCEPTION_STEP_CODE + 21, "标签已绑定"),


    /**
     * 确认绑定是否已完成
     */
    TAG_UID_BINDING_ERROR(CommonConstant.DEFAULT_USER_ERROR_CODE + JYZBConstant.JYZB_EXCEPTION_STEP_CODE + 22, "确认绑定是否已完成"),

    /**
     * 标签重复
     */
    TAG_INFO_REPEAT_ERROR(CommonConstant.DEFAULT_USER_ERROR_CODE + JYZBConstant.JYZB_EXCEPTION_STEP_CODE + 23, "标签重复"),
    ;


    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    ProductExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
