package com.junmp.jyzb.api.bean.req;

import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = true)
public class UpdateReassignmentReq extends BaseRequest {
    /**
     * id
     */
    private String id;

    private String userId;

    /**
     * 工作流id
     */
    private String processDefinitionId;

    /**
     * 调岗警员id
     */
    private String policeId;

    /**
     * 调岗警员姓名
     */
    private String policeName;

    /**
     * 警员带走装备
     */
    private String eqsList;

    /**
     * 组织机构id（警员原组织机构id）
     */
    private Long orgId;

    /**
     * 目标组织机构id
     */
    private Long targetOrgId;

    /**
     * 调岗原因
     */
    private String note;

    /**
     * 审核状态(none未接入工作流，working审批中，finished审批完成)
     */
    private String examineState;

    /**
     * 开始时间
     */
    private Date startTime;
    /**
     * 结束时间
     */
    private Date endTime;
    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 创建人员
     */
    private String createUser;

    /**
     * 更新人员
     */
    private String updateUser;

    /**
     * 排序规则
     */
    private String order;
    /**
     * 排序字段
     */
    private String column;
}
