package com.junmp.jyzb.api.bean.req;


import com.junmp.jyzb.api.bean.Validator.IsNumber;
import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
public class UpdateOrderReq extends BaseRequest implements Serializable {
    @NotBlank(message = "id不能为空",groups = {edit.class})
    private String id;
    private String userId;
    private String examineState;
    private String orderState;
    /**
     * 单据类型：入库单/出库单
     */
    @NotNull(message = "状态不能为空", groups = {updateStatus.class})
    private String orderType;
    /**
     * 工作流ID
     */
    private String  processDefinitionId;


    /**
     * 单据业务类型
     */
//    @IsDateTime(format = "yyyy-MM-dd HH:mm:ss", message = "字段必须是有效的日期或时间")
    private String  bussinessType;
    /**
     * 订单号
     */
    private String  orderCode;

    /**
     * 业务单据单号
     */
    private String bussinessCode;
    /**
     * 发物单位
     */
//    @IsNumber(message = "startOrgId必须是数字",groups = {add.class})
    private Long  startOrgId;
    /**
     * 发物单位名称
     */
    private String  startOrgName;

    /**
     * 收物单位
     */
    private Long  endOrgId;
    /**
     * 收物单位名称
     */
    private String  endOrgName;
    /**
     * 供应商id
     */
    private String supplierId;
    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 发物单位负责人id
     */
//    @IsNumber(message = "startOrgUserId必须是数字",groups = {add.class})
    private String  startOrgUserId;
    /**
     * 发物单位负责人姓名
     */
    private String  startOrgUserName;
    /**
     * 收物单位负责人id
     */
    @IsNumber(message = "endOrgUserId必须是数字",groups = {add.class})
    private String  endOrgUserId;
    /**
     * 收物单位负责人姓名
     */
    private String  endOrgUserName;
    /**
     * 总价格
     */
    private BigDecimal price;
    /**
     * 应入库数量
     */
    private Integer  inventoryQuantity;
    /**
     * 实际入库数量
     */
    private Integer actualQuantity;
    /**
     * 附件地址
     */
    private String  attachmentLocation;
    /**
     * 单据包含的物资集合
     */
    private String  invList;
    /**
     * 表单内容
     */
    private String  formItem;

//    /**
//     * 表单内容
//     */
//    private String  detailList;
    /**
     * 删除装备列表
     */
    private List<Long>  deleteList;
    /**
     * 明细列表
     */
    private List<UpdateOrderDetailReq>  detailList;

    /**
     * 生产厂商id
     */
    private String manufacturerId;

    /**
     * 调拨类型（2支拨，1价拨），调拨出入库才有
     */
    private Integer transferType;

    /**
     * 归还人，归还入库特有
     */
    private String returnUserId;

    private Date useDate;

    private String createUser;
    private String updateUser;

    //备注
    private String note;

}

