package com.junmp.jyzb.api.bean.query;
import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = true)
public class QueryBusFormReq extends BaseRequest {

    /**
     * id
     */
    private String id;

    /**
     * 工作流id
     */
    private String processId;

    /**
     * 单据业务类型
     */
    @NotBlank(message = "业务单据类型不能为空",groups = {detail.class})
    private String bussinessType;

    /**
     * 单据编号
     */
    private String bussinessCode;

    /**
     * 组织机构id
     */
    @NotNull(message = "组织机构id不能为空",groups = {detail.class})
    private Long orgId;

    /**
     * 组织机构名称
     */
    private String orgName;

    /**
     * 发物单位id
     */
    private Long startOrgId;

    /**
     * 发物单位
     */
    private String startOrgName;

    /**
     * 收物单位id
     */
    private Long endOrgId;

    /**
     * 收物单位
     */
    private String endOrgName;

    /**
     * 审核状态
     */
    private String examineState;

    /**
     * 价格
     */
    private BigDecimal price;

    /**
     * 数量
     */
    private Integer inventoryQuantity;

    /**
     * 附件地址
     */
    private String attachmentLocation;

    private String agentId;
    /**
     * 经办人
     */
    private String agent;


    /**
     * 归还人id
     */
    private String returnUserId;

    /**
     * 归还人
     */
    private String returnUser;

    /**
     * 归还日期
     */
    private Date returnDate;

    /**
     * 申请时间
     */
    private Date applyTime;

    /**
     * 申请人
     */
    private String applyUser;

    /**
     * 申请人id
     */
    private String applyUserId;

    /**
     * 调拨类型（2支拨，1价拨）
     */
    private Integer allocateType;

    /**
     * 备注
     */
    private String note;

    /**
     * 供应商id
     */
    private String supplierId;

    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 仓库id
     */
    private String warehouseId;

    /**
     * 装备详情
     */
    private String detailList;


    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 排序字段
     */
    private String column;

    /**
     * 排序规则
     */
    private String order;

    /**
     * 报废类型（1报废出库，2移入报废区）
     */
    private Integer type;

    /**
     * 维修单位id
     */
    private String repairId;
    /**
     * 维修单位名称
     */
    private String repairName;
    /**
     * 销毁、报废单位id
     */
    private String destoryId;
    /**
     * 销毁、报废单位名称
     */
    private String destoryName;
}
