package com.junmp.jyzb.api.bean.query;

import com.baomidou.mybatisplus.annotation.TableField;
import com.junmp.jyzb.api.bean.dto.LogDetailDto;
import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NonNull;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
public class LogSummaryReq extends BaseRequest {
    /**
     * 出入库汇总ID
     */
    private Integer id;

    /**
     * 组织机构ID
     */
    @NotNull(message = "组织机构id不能为空",groups = {detail.class})
    private Long orgId;

    /**
     * 组织机构名称
     */
    private String orgName;

    /**
     * 单据id
     */
    private String orderMainId;

    /**
     * 存储ID
     */
    private String locationId;

    /**
     * 箱门id
     */
    private String cabinetboxId;

    /**
     * 存储名称：XX仓库，XX单警柜
     */
    private String locationName;

    /**
     * 0仓库，1单警柜
     */
    private Integer locationType;

    /**
     * 设备标识
     */
    private String device;

    /**
     * 出入设备:0手持机/1单警柜/2通道
     */
    private Integer deviceType;

    /**
     * 操作时间
     */
    private Date useTime;

    /**
     * 业务类型
     */
    private String bussinessType;
    /**
     * 操作人员姓名
     */
    private String userName;

    /**
     * 出入库类型:0出库/1入库
     */
    private Integer outInState;

    /**
     * 照片信息
     */
    private String picture;

    /**
     * 装备记录集合，警棍、盾牌
     */
    private String equipmentList;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新人员
     */
    private String updateUser;

    /**
     * 创建人员
     */
    private String createUser;
    /**
     * 装备详细信息
     */
    private List<LogDetailReq> logList;

    private String typeId;

}
