package com.junmp.jyzb.api.exception.enums;

import com.junmp.jyzb.api.constant.JYZBConstant;
import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

@Getter
public enum SupplierExceptionEnum implements IExceptionEnum {
    /**
     * 供应商信息不存在
     */
    SUPPLIER_NOT_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE , "供应商信息不存在"),

    /**
     * 产品信息不存在
     */
    PRODUCT_SKU_NOT_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE , "号型不存在"),

    /**
     * 厂商名称已存在
     */
    SUPPLIER_NAME_IS_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE, "厂商名称已存在"),

    SUPPLIER_CODE_IS_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE, "厂商编码已存在"),
    ;


    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    SupplierExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
